package costo.kml2java.framework.channels;

import costo.kml2java.framework.IProvidedService;
import costo.kml2java.framework.IRequiredService;
import costo.kml2java.framework.IService;
import costo.kml2java.framework.exceptions.ServiceException;

public class AssemblyChannel extends Channel {

	/**
	 * @param name
	 * @param owner
	 * @param caller
	 * @param provider
	 */
	public AssemblyChannel(String name, AssemblyBinding owner, IRequiredService caller, IProvidedService provider) {
		super(name, owner, caller, provider);
	}

	@Override
	public String toString() {
		String str = super.toString();
		str += "- AssChan \n";
		return str;
	}

	/**
	 * Start the provided service
	 */
	@Override
	public void open() {
		super.open();
		try {
			getProvider().start();
		} catch (ServiceException e) {

			e.printStackTrace();
		}
	}

	public IProvidedService getProvider() {
		return (IProvidedService) server;
	}

	public IRequiredService getCaller() {
		return (IRequiredService) client;
	}

	/**
	 * Stop the processes
	 */
	public void cut(IService source) {
		super.cut(source);
		// FIXME Stop the services but the problem is to avoid circles provide a parameter ?
		if (this.getOwner() != null) {
			getOwner().closedChannel(this); 
		}
	}

	public void close(IService source) {
		super.close(source);
		// FIXME Stop the services but the problem is to avoid circles provide a parameter ?
		if (this.getOwner() != null) {
			getOwner().closedChannel(this); 
		}
	}

}
