package costo.kml2java.framework.channels;

import java.util.ArrayList;
import java.util.HashMap;

import costo.kml2java.framework.ExecutableComponent;
import costo.kml2java.framework.ExecutionContext;
import costo.kml2java.framework.IProvidedService;
import costo.kml2java.framework.IRequiredService;
import costo.kml2java.framework.IService;
import costo.kml2java.framework.IServiceEvolutionListener;

/**
 * @author Pascal
 * 
 *         The binding represents the static description of links. Two passes 1. names 2. instances lazy evaluation
 * 
 *         => static creation of the names once from Kmelia links. Active bindings are channels.
 * 
 *         For each client service call, there will be an active binding. dynamic creation : on the demand (service call)
 * 
 *         TODO sublink and channel management to design
 * 
 *         ordering the bindings ? yes but in the subclasses in order to avoid cast operations assembly client = required -> server = provided
 *         promotion inner - outer
 */
public abstract class ExecutionBinding {

	/**
	 * from the link name, never changed
	 */
	protected String name;
	protected ExecutionContext owner;
	protected ArrayList<IChannelListener> channelsListeners = new ArrayList<IChannelListener>();

	/**
	 * static description (names only) component and service names provided at the creation
	 */
	protected String cclientname;
	protected String cservername;
	protected String sclientname;
	protected String sservername;

	protected HashMap<String, Channel> activeBindings;

	/**
	 * client, server and chan are null and instantiated later (once called) a kind of implementation structure
	 */
	@Deprecated
	protected Boolean isInstantiated;

	/**
	 * preserve the link substructure ? this structure is built using the behaviour methods
	 */
	protected ExecutionBinding superBinding;
	protected HashMap<String, ExecutionBinding> namedSubBindings;
	private int totalNbChan;
	private boolean active;

	/**
	 * @param name
	 * @param owner
	 * @param cclientname
	 * @param cservername
	 * @param sclientname
	 * @param sservername
	 *            Creates a static bindings by default it is not instantiated
	 * @see instantiateLink
	 */
	public ExecutionBinding(String name, ExecutionContext owner, String cclientname, String cservername, String sclientname, String sservername) {
		super();
		this.name = name;
		this.owner = owner;
		this.cclientname = cclientname;
		this.cservername = cservername;
		this.sclientname = sclientname;
		this.sservername = sservername;
		this.activeBindings = new HashMap<String, Channel>();
		this.namedSubBindings = new HashMap<String, ExecutionBinding>();
		//this.channelsListeners.add(new DefaultChannelListener());
	}
	
	/**
	 * names simple getters
	 * 
	 * @return values suppose no setters
	 */
	public String getName() {
		return name;
	}

	public String getCclientname() {
		return cclientname;
	}

	public String getCservername() {
		return cservername;
	}

	public String getSclientname() {
		return sclientname;
	}

	public String getSservername() {
		return sservername;
	}

	/**
	 * @return the upper context
	 */
	public ExecutionContext getOwner() {
		return owner;
	}

	/**
	 * @return the upper context
	 */
	public Boolean isInstantiated() {
		return (this.activeBindings.size() != 0);
	}

	// instance management - lazy evaluation

	public String getNewChannelName() {
		return this.getName() + this.getNewNumber();
	}

	private int getNewNumber() {
		return this.totalNbChan++;
	}

	public void addChannelListener(IChannelListener l) {
		this.channelsListeners.add(l);
	}

	private void addListeners(Channel chan) {
			for (IChannelListener l : this.channelsListeners) {
				chan.addChannelListener(l);
			}
	}

	/**
	 * TODO find a way to create channels or delegate to - the provider - the required parameter ???
	 * 
	 * TODO test if super or sub links... to be customised in subclasses
	 */
//	public Channel instantiateLink(String kindofchannel) {
//		String newChanName = this.getNewChannelName();
//		Channel chan = this.createServicesandChannel(newChanName, kindofchannel);
//		this.activeBindings.put(newChanName, chan);
//		return chan;
//	}

	public Channel instantiateLink(String kindofchannel, ExecutableComponent clientComponent, IRequiredService clientService) {
		String newChanName = this.getNewChannelName();
		//waits for a free channel
		while (active) {
			;
		}
		setActive(true);
		Channel chan = this.createServicesandChannel(newChanName, kindofchannel, clientComponent, clientService);
		this.addListeners(chan);
		//this.activeBindings.put(newChanName, chan); 
		//only one in this version
		return chan;
	}

	/**
	 * @param newChanName
	 *            related to the binding
	 * @param kindofchannel
	 *            not used yet
	 * @param clientComponent
	 *            the effective executable client component
	 * @param clientService
	 *            the effective executable client service
	 * @return the new communication channel where the provider is connected
	 */
	abstract protected Channel createServicesandChannel(String newChanName, String kindofchannel, ExecutableComponent clientComponent,
			IRequiredService clientService);

//	@Deprecated
//	public abstract Channel createServicesandChannel(String chanName, String kindofchannel);

	@Override
	public String toString() {
		// String str = super.toString();
		String str = "EB-" + this.getName() + "(" + cclientname + ":" + sclientname + "-" + cservername + ":" + sservername + ")";
		if (this.isInstantiated()) {
			str += "-active\n";
		}
		str += "owner: " + this.owner.toString() + "\n";
		return str;
	}

	// binding composition

	public ExecutionBinding getSuperBinding() {
		return superBinding;
	}

	public void setSuperBinding(ExecutionBinding superExecutionBinding) {
		this.superBinding = superExecutionBinding;
	}

	public HashMap<String, ExecutionBinding> getNamedSubBindings() {
		return namedSubBindings;
	}

	public void setNamedSubExecutionBindings(HashMap<String, ExecutionBinding> namedSubExecutionBindings) {
		this.namedSubBindings = namedSubExecutionBindings;
	}

	/**
	 * @param bname
	 * @param subBinding
	 *            overriden possible - no control ?
	 */
	public void addNamedSubExecutionBindings(String bname, ExecutionBinding subBinding) {
		this.namedSubBindings.put(bname, subBinding);
		subBinding.setSuperBinding(this);
	}

	public void closedChannel(Channel channel) {
		active = false;
		// activeBindings.remove(chan);
	}

	/**
	 * @return the active
	 */
	public boolean isActive() {
		return active;
	}

	/**
	 * @param active
	 *            the active to set
	 */
	public void setActive(boolean active) {
		this.active = active;
	}

	public boolean messageMapping(String channel, String message,
			ICommunication comm) {
		//no possible channel matching at this level
		if (message.equals(this.getSservername()))
			return comm.getMessageName().equals(this.getSclientname());
		else 
			return comm.getMessageName().equals(this.getSservername());
	}

}
