package costo.kml2java.framework.channels;

import costo.kml2java.framework.IService;
import costo.kml2java.framework.exceptions.KmlCommunicationException;

/**
 * 
 * @author ardourel-g modified by PA
 */
public interface IChannel {

	public String getName() ;

		/**
	 * @param channel
	 *            : the Kmelia channel name
	 * @param message
	 * @param paramtypes
	 * @param orig
	 * @return
	 */
	public Object[] receiveMessage(String channel, String message, Class<?>[] paramtypes, IService orig);

	public void emitMessage(String channel, String message, Object[] params, IService orig);

	// public void ackMessageSend(String channel, String message, Object[] params, ServiceAtExecution orig);

	/**
	 * @param channel
	 * @param message
	 * @param params
	 * @param orig
	 * @throws KmlCommunicationException
	 *       a first attempt of exception handling
	 */
	public void callService(String channel, String message, Object[] params, IService orig) throws KmlCommunicationException;

	// public void ackServiceCall(String channel, String message, Object[] params, ServiceAtExecution orig) throws KmlCommunicationException;

	public void returnService(String channel, String message, Object[] params, IService orig);

	public Object[] receiveServiceCall(String channel, String message, Class<?>[] paramtypes, IService orig);

	public Object[] receiveServiceReturn(String channel, String message, Class<?>[] paramtypes, IService orig);

	// public boolean canReceiveMessage(ICommunication comm, ServiceAtExecution orig);

	public void addChannelListener(IChannelListener l);

	public void removeChannelListener(IChannelListener l);
	
	public void open ();

	public void close (IService source);
	
	//public void close(ExecutionBinding source);

}
