package costo.kml2java.framework.channels;

import costo.kml2java.framework.IProvidedService;
import costo.kml2java.framework.IRequiredService;
import costo.kml2java.framework.IService;
import costo.kml2java.framework.exceptions.KmlCommunicationException;

public class RPromotionChannel extends Channel {

//	public RPromotionChannel(String name, PromotionBinding owner, IService client, IService server) {
//		super(name, owner, client, server);
//	}


	/**
	 * @param name
	 * @param owner
	 * @param caller
	 * @param provider
	 */
	public RPromotionChannel(String name, RPromotionBinding owner, IRequiredService base, IRequiredService promoted) {
		super(name, owner, base, promoted);
	}

	@Override
	public String toString() {
		String str = super.toString();
		str += "- RPromChan \n";
		return str;
	}

	/**
	 * @return the promoted service
	 */
	public IRequiredService getPromotedService() {
		return (IRequiredService) server;
	}

	/**
	 * @return the base service
	 */
	public IRequiredService getBaseService() {
		return (IRequiredService) client;
	}
	
	/**
	 * @see costo.kml2java.framework.channels.Channel#callService(java.lang.String, java.lang.String, java.lang.Object[],
	 *      costo.kml2java.framework.IService)
	 */
	@Override
	public void callService(String channel, String message, Object[] params, IService client) throws KmlCommunicationException {
		this.getPromotedService().callService(channel, message, params, client);
	}


	/* (non-Javadoc)
	 * @see costo.kml2java.framework.channels.Channel#emitMessage(java.lang.String, java.lang.String, java.lang.Object[], costo.kml2java.framework.IService)
	 */
	@Override
	public void emitMessage(String channel, String message, Object[] params, IService orig) {
		if (orig==this.getPromotedService()) 
		 	this.getBaseService().emitMessage(channel, message, params, orig);
			else this.getPromotedService().emitMessage(channel, message, params, orig);
	}

	/**
	 * @see costo.kml2java.framework.channels.PromotionChannel#receiveMessage(java.lang.String, java.lang.String, java.lang.Class<?>[],
	 *      costo.kml2java.framework.IService)
	 */
	@Override
	public Object[] receiveMessage(String channel, String message, Class<?>[] paramtypes, IService orig) {
		if (orig==this.getPromotedService()) 
		 	return this.getBaseService().receiveMessage(channel, message, paramtypes, orig);
			else return this.getPromotedService().receiveMessage(channel, message, paramtypes, orig);
	}


	/**
	 * @see costo.kml2java.framework.channels.Channel#receiveServiceReturn(java.lang.String, java.lang.String, java.lang.Class<?>[],
	 *      costo.kml2java.framework.IService)
	 */
	@Override
	public Object[] receiveServiceReturn(String channel, String message, Class<?>[] paramtypes, IService orig) {
		return this.getPromotedService().receiveServiceReturn(channel, message, paramtypes, orig);
	}

	public void ack(IRequiredService sender, int commtype) {
		if (sender==this.getPromotedService()) 
	 	this.getBaseService().ack(this, commtype);
		else this.getPromotedService().ack(this, commtype);
	}


}
