package costo.kml2java.framework.kmllibs;

import java.util.Arrays;
import java.util.HashSet;

public class KmlSet<T> extends HashSet<T> {

	/**
	 * 
	 */
	private static final long serialVersionUID = -3389987080895018504L;

	// FUNCTION union : setOf LIKE; setOf LIKE ->setOf LIKE .
	public KmlSet<T> unionK(KmlSet<T> other) {
		KmlSet<T> newset = new KmlSet<T>();
		newset.addAll(this);
		newset.addAll(other);
		return newset;
	}

	@Override
	public T[] toArray() {
		return this.toArray();
	}

	public KmlSet<T> fromArray(T[] other) {
		KmlSet<T> newset = new KmlSet<T>();
		newset.addAll(Arrays.asList(other));
		return newset;
	}

	// FUNCTION count : setOf LIKE;LIKE ->Integer .

	public int countK(T t) {
		if (this.contains(t))
			return 1;
		return 0;
	}

	// FUNCTION excludes : setOf LIKE;LIKE ->Boolean .
	public boolean excludesK(T t) {
		return !(this.contains(t));

	}

	// FUNCTION excludesAll : setOf LIKE;setOf LIKE ->Boolean .

	public KmlSet<T> excludesAllK(KmlSet<T> other) {
		KmlSet<T> newset = new KmlSet<T>();
		newset.addAll(this);
		super.removeAll(other);
		this.addAll(newset);
		return newset;
	}

	// FUNCTION excluding : setOf LIKE;LIKE -> setOf LIKE .
	public KmlSet<T> excludingK(T t) {
		KmlSet<T> newset = new KmlSet<T>();
		newset.addAll(this);
		newset.remove(t);
		return newset;
	}

	// FUNCTION add : setOf LIKE;LIKE -> setOf LIKE .

	public KmlSet<T> addK(T t) {
		KmlSet<T> newset = new KmlSet<T>();
		newset.addAll(this);
		newset.add(t);
		return newset;
	}

	// FUNCTION includes : setOf LIKE;LIKE ->Boolean .
	public boolean includesK(T t) {
		return (this.contains(t));

	}

	// FUNCTION includesAll : setOf LIKE;setOf LIKE ->Boolean .
	public boolean includesAllK(KmlSet<T> t) {
		return (this.containsAll(t));

	}

	// FUNCTION including : setOf LIKE;LIKE -> setOf LIKE .
	public KmlSet<T> includingK(T t) {

		return this.addK(t);
	}

	// FUNCTION intersection : setOf LIKE;setOf LIKE ->setOf LIKE .
	public KmlSet<T> intersectionK(KmlSet<T> t) {
		KmlSet<T> newset = new KmlSet<T>();

		newset.addAll(this);
		newset.retainAll(t);
		return newset;
	}

	// FUNCTION isEmpty : setOf LIKE ->Boolean .
	public boolean isEmptyK() {
		return this.isEmpty();
	}

	// FUNCTION notEmpty : setOf LIKE ->Boolean .
	public boolean notEmptyK() {
		return !this.isEmpty();
	}

	// FUNCTION size : setOf LIKE ->Integer .
	public int sizeK() {
		return this.size();
	}

	// FUNCTION KWin : LIKE; setOf LIKE -> Boolean .
	public boolean inK(T t) {
		return (this.contains(t));

	}

	// FUNCTION notIn : setOf LIKE ; LIKE -> Boolean .
	public boolean notInK(T t) {
		return !(this.contains(t));

	}

	// FUNCTION oneOf : setOf LIKE -> LIKE .
	public T oneOfK() {

		int s = this.size();
		if (s == 0)
			return null;
		@SuppressWarnings("unchecked")
		T[] tab = this.toArray();
		int index = (int) (Math.random() * s);
		if (index == s) {
			index = 0;
		}
		return tab[index];
	}

	// pick an element
	// FUNCTION differ : setOf LIKE ; setOf LIKE ->setOf LIKE .
	public KmlSet<T> differK(KmlSet<T> other) {
		KmlSet<T> newset = new KmlSet<T>();

		newset.addAll(this);
		newset.removeAll(other);
		return newset;

	}

	@Override
	public String toString() {
		StringBuilder temp = new StringBuilder();
		for (T t : this) {
			temp.append(t.toString());
			temp.append(" ");
		}
		return temp.toString();
	}

	// FUNCTION setFindElem : setOf LIKE; LIKE; Boolean -> LIKE .
	public T setFindElem(KmlElemPredicate<T> pred) {
		for (T t : this) {
			if (pred.valid(t))
				return t;
		}
		return null;
	}

	// FUNCTION setExistElem : setOf LIKE; LIKE; Boolean -> Boolean .
	public boolean setExistElem(KmlElemPredicate<T> pred) {
		for (T t : this) {
			if (pred.valid(t))
				return true;
		}
		return false;
	}

	// FUNCTION setSelectElem : setOf LIKE; LIKE; Boolean -> setOf LIKE .
	public KmlSet<T> setSelectElem(KmlElemPredicate<T> pred) {
		KmlSet<T> newset = new KmlSet<T>();

		for (T t : this) {
			if (pred.valid(t)) {
				newset.add(t);
			}
		}
		return newset;
	}

	// FUNCTION setForAllElem : setOf LIKE; LIKE; Boolean -> Boolean .
	public boolean setForAllElem(KmlElemPredicate<T> pred) {
		for (T t : this) {
			if (!pred.valid(t))
				return false;
		}
		return true;
	}

	// FUNCTION setIterate : setOf LIKE; LIKE; ANYTYPE; Void -> Void .
	public void setIterate(KmlElemIterator<T> pred) {
		for (T t : this) {
			pred.run(t);
		}

	}

}
