package costo.kml2java.framework.test;

import java.lang.reflect.Field;

import costo.kml2java.framework.kmllibs.KmlStruct;

public abstract class AbstractDataProvider implements IDataInjector {

	public Object[] giveObjects(Class<?>[] classes) {
		if (classes == null || classes.length == 0)
			return null;

		Object[] result = new Object[classes.length];
		for (int i = 0; i < classes.length; i++) {
			result[i] = giveObject(classes[i]);
		}
		return result;
	}

	public Object giveObject(Class<?> clazz) {
		// Object result = null;
		if (clazz.equals(String.class))
			return giveString();
		if (clazz.equals(Integer.class))
			return giveInteger();
		if (clazz.equals(Boolean.class))
			return giveBoolean();
		if (clazz.isEnum())
			return giveEnum(clazz);
		if (KmlStruct.class.isAssignableFrom(clazz))
			return giveKmlStruct(clazz);
		return null;

	}

	public Object giveKmlStruct(Class<?> clazz) {
		try {
			Object result = clazz.newInstance();
			for (Field f : clazz.getDeclaredFields()) {
				f.set(result, this.giveObject(f.getType()));
			}
			return result;
		} catch (InstantiationException e) {
			//
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			//
			e.printStackTrace();
		}
		return null;
	}

	abstract public Object giveEnum(Class<?> clazz);

	abstract public Object giveBoolean();

	abstract public Object giveInteger();

	abstract public Object giveString();

	/**
	 * @see costo.kml2java.framework.test.IDataInjector#giveNamedObjects(java.lang.String, java.lang.Class<?>[])
	 */
	@Override
	public Object[] giveNamedObjects(String name, Class<?>[] classes) {

		return this.giveObjects(classes);
	}

	/**
	 * @see costo.kml2java.framework.test.IDataInjector#giveNamedObject(java.lang.String, java.lang.Class)
	 */
	@Override
	public Object giveNamedObject(String message, Class<?> clazz) {

		return this.giveObject(clazz);
	}

}