package costo.kml2java.framework.test;

import java.io.Serializable;

import costo.kml2java.framework.IProvidedService;
import costo.kml2java.framework.IService;
import costo.kml2java.framework.channels.IChannelListener;
import costo.kml2java.framework.exceptions.UnsatisfiedPostconditionException;
import costo.kml2java.framework.exceptions.UnsatisfiedPreconditionException;

/**
 * Random channel. <br>
 * Ignore all sends and calls if no replacement service has been specified.<br>
 * Checks Pre otherwise and return exception if failed<br>
 * 
 * Return random values of desired types when asked for receptions or returns <br>
 * (checks Posts before sending and throw exception if it can't satisfy them) after MaxTries<br>
 * Can always receive messages
 * 
 * @author ardourel-g
 * 
 */
public class RandomChannel implements Serializable, InjectorChannel {
	/**
	 * 
	 */
	private static final long serialVersionUID = -372648619449496370L;

	public RandomChannel(IProvidedService replaced, IDataInjector randomsource) {
		super();
		this.replaced = replaced;
		this.randomsource = randomsource;
	}

	public RandomChannel(IProvidedService replaced) {
		super();
		this.replaced = replaced;
	}

	public RandomChannel() {
		super();
	}

	public static final RandomChannel instance = new RandomChannel();
	private IDataInjector randomsource = new RandomProvider();
	transient private IProvidedService replaced;
	transient private IProvidedService caller;
	private int maxtries = 50;

	@Override
	public String getName() {
		return "A random channel";
	}

	@Override
	public void callService(String channel, String message, Object[] params, IService orig) {
		if (replaced != null && !replaced.isPreSatisfiedWithTheseParameters(params))
			throw new UnsatisfiedPreconditionException(replaced, replaced.getName() + " pre failed");
	}

	@Override
	public void emitMessage(String channel, String message, Object[] params, IService orig) {

	}

	@Override
	public Object[] receiveMessage(String channel, String message, Class<?>[] paramtypes, IService orig) {

		return randomsource.giveObjects(paramtypes);
	}

	/**
	 * START - maybe should be different (or simply the caller is fixed)
	 */
	@Override
	public Object[] receiveServiceCall(String channel, String message, Class<?>[] paramtypes, IService orig) {
		Object[] result = randomsource.giveObjects(paramtypes);
		if (caller != null) {
			int nbtries = 0;
			while (nbtries < getMaxtries()) {
				if (caller.isPreSatisfiedWithTheseParameters(result))
					return result;
				// FIXME : UGLY le test de Post doit etre fait au moins 1 fois
				nbtries++;
				if (nbtries < getMaxtries()) {
					result = randomsource.giveObjects(paramtypes);
				}
			}
			throw new UnsatisfiedPreconditionException(caller, caller.getName() + " pre failed");
		}
		return result;
	}

	/**
	 * a service is waiting for a RCV_RESULT generate, if replacement service has been specified, tries to ensure its Post at most Maxtries times
	 * Throw Exception otherwise
	 * 
	 * @param channel
	 * @param message
	 * @param paramtypes
	 */
	@Override
	public Object[] receiveServiceReturn(String channel, String message, Class<?>[] paramtypes, IService orig) {
		Object[] result = randomsource.giveObjects(paramtypes);
		if (replaced != null) {
			int nbtries = 0;
			while (nbtries < getMaxtries()) {
				if (replaced.isPostSatisfiedWithTheseParameters(result))
					return result;
				// FIXME : UGLY le test de Post doit etre fait au moins 1 fois
				nbtries++;
				if (nbtries < getMaxtries()) {
					result = randomsource.giveObjects(paramtypes);
				}

			}
			throw new UnsatisfiedPostconditionException(replaced, replaced.getName() + " post failed");
		}
		return result;
	}

	@Override
	public void returnService(String channel, String message, Object[] params, IService orig) {

	}

	/**
	 * @return the maxtries
	 */
	public int getMaxtries() {
		if (randomsource.isExact())
			return 1;
		return maxtries;
	}

	/**
	 * @param maxtries
	 *            the maxtries to set
	 */
	public void setMaxtries(int maxtries) {
		this.maxtries = maxtries;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("RandomChannel [randomsource=");
		builder.append(randomsource);
		builder.append(", replaced=");
		builder.append(replaced);
		builder.append(", maxtries=");
		builder.append(maxtries);
		builder.append("]");
		return builder.toString();
	}

	/**
	 * @see costo.kml2java.framework.test.InjectorChannel#getCaller()
	 */
	@Override
	public IProvidedService getCaller() {
		return caller;
	}

	/**
	 * @see costo.kml2java.framework.test.InjectorChannel#setCaller(costo.kml2java.framework.ProvidedService)
	 */
	@Override
	public void setCaller(IProvidedService caller) {
		this.caller = caller;
	}

	@Override
	public IDataInjector getDataProvider() {

		return this.randomsource;
	}

	@Override
	public void setDataProvider(IDataInjector injector) {
		this.randomsource = injector;

	}

	@Override
	public void addChannelListener(IChannelListener l) {
		// TODO Auto-generated method stub

	}

	@Override
	public void removeChannelListener(IChannelListener l) {
		// TODO Auto-generated method stub

	}

	@Override
	public void open() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void close(IService source) {
		// TODO Auto-generated method stub
		
	}


}
