package costo.kml2java.framework.test;

import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import costo.kml2java.framework.ExecutableComponent;

public class ServTestCaseData {
	private String name;
	private String goal;
	private Map<String, Object> initvalues;
	/**
	 * contains the injectors
	 * 
	 */
	private Map<String, IDataInjector> datachannelMapping = new HashMap<String, IDataInjector>();

	public void reset() {
		for (IDataInjector inj : datachannelMapping.values()) {
			if (inj != null) {
				inj.reset();
			}
		}
	}

	public ServTestCaseData(String filename) throws IOException {
		this.loadInjectorMapping(filename);
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getGoal() {
		return goal;
	}

	public void setGoal(String goal) {
		this.goal = goal;
	}

	public Map<String, IDataInjector> getDatachannelMapping() {
		return datachannelMapping;
	}

	public void setDatachannelMapping(Map<String, IDataInjector> datachannelMapping) {
		this.datachannelMapping = datachannelMapping;
	}

	protected void loadInjectorMapping(String filename) throws IOException {
		Properties map = new Properties();

		map.load(new FileReader(filename));
		// key : chan names, value : filename of object injector ? bof
		for (@SuppressWarnings("rawtypes")
		Map.Entry entry : map.entrySet()) {

			String key = (String) entry.getKey();
			String value = (String) entry.getValue();
			if (key.equals("name")) {
				setName(value);
			} else if (key.equals("goal")) {
				setGoal(value);
				// } else if (key.equals("initComp")) {
				// initComp(value);
			} else {
				// if (key.startsWith("_")) {

				createMapping(key, value);
				// }
			}
		}

	}

	/**
	 * @param key
	 * @param value
	 */
	private void createMapping(String key, String value) {

		// if subinjector, create
		String[] splitkey = key.split("\\.");
		if (splitkey.length > 1) {
			// getorCreate Subinjector
			CompositeProvider compoInject = (CompositeProvider) getDatachannelMapping().get(splitkey[0]);
			if (compoInject == null) {
				compoInject = new CompositeProvider();
				// only one level
				getDatachannelMapping().put(splitkey[0], compoInject);

			}
			compoInject.putInjector(splitkey[1], newInjector(value));

		} else {
			getDatachannelMapping().put(key, newInjector(value));
			// System.out.println(key + "is mapped");
		}
	}

	void initComp(ExecutableComponent comp) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {

		CompositeProvider compoInject = (CompositeProvider) this.datachannelMapping.get("comp");
		if (compoInject == null)
			return;
		for (Map.Entry<String, IDataInjector> entry : compoInject.getMessagemap().entrySet()) {

			Field f = comp.getClass().getDeclaredField(entry.getKey());
			f.setAccessible(true);
			f.set(comp, entry.getValue().giveObject(f.getType()));

		}

	}

	IDataInjector newInjector(String value) {

		String[] split = value.split("#");
		String type = split[0];
		String params = split[1];
		if (type.equals("Random"))
			return new RandomProvider(params);
		if (type.equals("Sequence"))
			return new SequenceProvider(params);
		if (type.equals("File"))
			return new FileSequenceProvider(params);
		return null;
	}

	public static void main(String[] args) throws IOException {
		ServTestCaseData st = new ServTestCaseData("case00.txt");
		System.out.println(st.datachannelMapping);
		System.out.println(st.datachannelMapping.get("_test").giveNamedObject("hop", Integer.class));
		System.out.println(st.datachannelMapping.get("_test").giveNamedObject("hop", Integer.class));
	}
}