/**
 * 
 */
package costo.kml2java.framework.test;

import costo.kml2java.framework.IService;
import costo.kml2java.framework.IServiceEvolutionListener;
import costo.kml2java.framework.channels.IChannel;
import costo.kml2java.framework.config.ExecutionParameters;

/**
 * Evaluates a service evolution (add level of verification / qualifies channels verification (evolution-regressionb) ) currently just a logger
 * 
 * @author ardourel-g
 * 
 */
public class ServiceEvolutionValidator implements IServiceEvolutionListener {

	boolean active = ExecutionParameters.serviceListenerActivation;
	boolean debug = ExecutionParameters.serviceListenerActivation;
	
	/**
	 * @see costo.kml2java.framework.IServiceEvolutionListener#transitionFired(java.lang.String, java.lang.String,
	 *      costo.kml2java.framework.ExecutableService, java.lang.String, java.lang.Exception)
	 */
	@Override
	public void transitionFired(String tname, String currentState, IService serv, String log, Exception ex) {
		if (debug) {
			System.out.println("--SERV>> "+serv.getName() + " : state " + currentState + " - " + tname + " . " + log);
			System.out.println("--SERV>> "+serv.getStateSpace());
		}
	}

	@Override
	public void serviceError(IService serv, IChannel source, String message) {
		if (debug) {
		//System.err.println("--SERV-error>> "+serv.getName() + " : channel " + source.getName());
		System.err.println("--SERV-error>> "+message);
		}
	}

}
