package annotation;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

import toolbox.tool.ToolInterface;

/**
 * C'est une classe de test. 
 * On l'execute avec un fichier en parametre.
 * Cela remplacera toutes les lettres majuscules en minuscules.
 */
public class AnnotationFromModel implements ToolInterface {
	private String toolName;
	private ArrayList<String> contraints;
	private ArrayList<Object[]> conditions;
	
	public AnnotationFromModel(){
		this.toolName = "Annotation_From_Model";
		this.contraints = new ArrayList<String>();
		this.conditions = new ArrayList<Object[]>();
	}
	
	/**
	 * Methode d'execution du plugin. 
	 * @param param : c'est une liste de parametres d'execution. On laisse ouvert leur nombre et leur type
	 *					ici, il doit y avoir au moins comme parametre le nom du fichier a parcourir.
	 */
	public void execute(ArrayList<Object> param) {
		BufferedReader in = null;
		try {
			in = new BufferedReader(new FileReader((String)param.get(0)));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		String str;
		ArrayList<String> txt = new ArrayList<String>();
		try {
			while ((str=in.readLine()) != null) {
				txt.add(str.toLowerCase());
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		try {
			in.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		PrintWriter out = null;
		try {
			out = new PrintWriter(new FileWriter((String)param.get(0)));
		} catch (IOException e) {
			e.printStackTrace();
		}
		for (String s : txt){
			out.println(s);
		}
		out.close();
	}
	
	/**
	 * @return toolName : le nom du plugin
	 */
	public String getToolName() {
		return this.toolName;
	}
	
	public String toString() {
		return this.toolName;
	}

	public ArrayList<String> getContraints() {
		return contraints;
	}

	public void setContraints(ArrayList<String> contraints) {
		this.contraints = contraints;
	}

	public ArrayList<Object[]> getConditions() {
		return conditions;
	}

	public void setCondition(ArrayList<Object[]> conditions) {
		this.conditions = conditions;
	}

}
