package toolbox;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import toolbox.editors.ToolboxCodeScanner;
import toolbox.editors.ToolboxPartitionScanner;
import toolbox.editors.ToolboxTextAttributeProvider;

import toolbox.tool.ToolInterface;

/**
 * La classe activator controle le cycle de vie du plugin.
 */
public class Activator extends AbstractUIPlugin {
	// Liste des noms des plug-ins
	static public LinkedList<String> listeNom;
	
	static public HashMap<String,ToolInterface> tablePlugin;
	
	// L'ID du plug-in
	public static final String PLUGIN_ID = "Toolbox";
	
	public static String TOOLBOX_PARTITIONING = "__toolbox_partitioning";

	// Une instance partagee
	private static Activator plugin;
	
	// Partitionneur
	private ToolboxPartitionScanner toolboxPartitionScanner;
	
	// Conteneur d'attributs pour le texte 
	private ToolboxTextAttributeProvider fTextAttributeProvider;
	
	// Scanner pour la coloration des partitions de code
	private ToolboxCodeScanner fCodeScanner;
	
	/**
	 * Le constructeur
	 */
	public Activator() {
		this.listeNom = new LinkedList<String>();
		this.tablePlugin = new HashMap<String, ToolInterface>();
		
		IExtensionRegistry reg = Platform.getExtensionRegistry();
	    IConfigurationElement[] elements = reg.getConfigurationElementsFor("Toolbox.sousPlugin");
	    
	    ArrayList<ToolInterface> contributors = new ArrayList<ToolInterface>();
	    for (int j = 0; j < elements.length; j++) {
	         Object obj = null;
			try
			{
				obj = elements[j].createExecutableExtension("class");
			}
			catch (CoreException e)
			{
				e.printStackTrace();
			}
	         contributors.add((ToolInterface)obj);
	    }
	    
	    for(ToolInterface t : contributors)
	    {
	    	listeNom.add(t.getToolName());
	    }
	    
	    
	    
	    
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Retourne l'intance partagee
	 *
	 * @return l'intance partagee
	 */
	public static Activator getDefault() {
		return plugin;
	}

	/**
	 * Retourne un descripteur d'image pour l'image donnee a l'adresse du plugin
	 *
	 * @param path le chemin
	 * @return le descripteur d'image
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}
	
	/**
	 * Renvoie le ToolboxPartitionScanner.
	 * @return Le ToolboxPartitionScanner.
	 */
	public ToolboxPartitionScanner getToolboxPartitionScanner() {
		if(toolboxPartitionScanner == null)
		{
			toolboxPartitionScanner = new ToolboxPartitionScanner();
		}
		return toolboxPartitionScanner;
	}
	
	/**
	 * Renvoie le conteneur d'attributs texte.
	 * @return Le conteneur.
	 */
	public ToolboxTextAttributeProvider getTextAttributeProvider() {
		if(fTextAttributeProvider == null) {
			fTextAttributeProvider = new ToolboxTextAttributeProvider();
		}
		return fTextAttributeProvider;
	}
	
	/**
	 * Renvoie le scanner de code Assembleur.
	 * @return Le scanner.
	 */
	public ToolboxCodeScanner getToolboxCodeScanner() {
		if(fCodeScanner == null) {
			fCodeScanner = new ToolboxCodeScanner(getTextAttributeProvider());
		}
		return fCodeScanner;
	}
}
