package toolbox;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ToolboxPluginViewActionDelegate implements IViewActionDelegate {
private IViewPart view;
	
	public void init(IViewPart view) {
		this.view = view;
	}

	public void run(IAction action) {
		InputDialog dialog = new InputDialog(view.getSite().getShell(),"Test","Veuillez taper un petit truc","",null); // new input dialog
		if( dialog.open()== IStatus.OK)
		{
			// Ouvre la boite de dialogue et attend pour le code de retour (status).
			// Si l'utilisateur clic sur ok alors on affiche la boite avec le message
			String value = dialog.getValue(); // Recuperation de la valeur entree par l'utilisateur.
			MessageBox box = new MessageBox(view.getSite().getShell(),SWT.ICON_INFORMATION);
			box.setMessage("Vous avez tapé : " + value);
			box.open();
		}
		else
		{
			MessageBox box = new MessageBox(view.getSite().getShell(),SWT.ICON_INFORMATION);
			box.setMessage("Aurevoir !");
			box.open();
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
		
	}
}
