package toolbox.editors;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

import toolbox.Activator;

public class ToolboxCodeScanner extends RuleBasedScanner {
	public static final String[] toolCodes = new String[Activator.listeNom.size()];
	public static final String[] reserved = new String[] {"begin", "end"};
	
	/**
	 * Détecteur de "mots" cles soit le snoms des plugins
	 */
	static class ToolboxWordDetector implements IWordDetector {
		/**
		 * Indique si le caractère passé en paramètre est valide à
		 * l'intérieur d'un mot.
		 * @param c Caractère à analyser.
		 * @return 	<code>true</code> si le caractère est valide.
		 * 			<code>false</code> sinon.
		 * @see org.eclipse.jface.text.rules.IWordDetector#isWordPart(char)
		 */
		public boolean isWordPart(char c) {
		    return (Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#' || c == '@' || c == '~' || c == '.' || c == '?');
		}
		
		/**
		 * Indique si le caractère passé en paramètre est valide au
		 * début d'un mot.
		 * @param c Caractère à analyser.
		 * @return 	<code>true</code> si le caractère est valide.
		 * 			<code>false</code> sinon.
		 * @see org.eclipse.jface.text.rules.IWordDetector#isWordStart(char)
		 */
		public boolean isWordStart(char c) {
			return (Character.isLetter(c) || c == '.' || c == '_' || c == '?' || c == '$');
		}
	}

	
	
	public ToolboxCodeScanner(ToolboxTextAttributeProvider provider) {
		int cpt = 0;
		for(String str : Activator.listeNom)
		{
			toolCodes[cpt] = str;
			cpt++;
		}
		
		// Contiendra les regles
		List<IRule> rules = new ArrayList<IRule>();

		/*
		 * Creation des tokens. Chaque token contient l'attribut
		 * à appliquer au texte correspondant.
		 */
		IToken keywordcode = new Token(provider.getAttribute(ToolboxTextAttributeProvider.KEYWORD_ATTRIBUTE));
		IToken reservedcode = new Token(provider.getAttribute(ToolboxTextAttributeProvider.RESERVED_ATTRIBUTE));
		IToken undefined = new Token(provider.getAttribute(ToolboxTextAttributeProvider.DEFAULT_ATTRIBUTE));
		rules.add(new WhitespaceRule(new IWhitespaceDetector() {public boolean isWhitespace(char c) {return Character.isWhitespace(c);}}));
		
		/*
		 * Creation de la regle pour les mots cles. En deux temps :
		 * Tout d'abord on parametre un detecteur qui va indiquer les
		 * caracteres valides pour le debut et le contenu d'un mot,
		 * puis on ajoute une liste de mots en indiquant quel token doit
		 * etre renvoye pour chacun.
		 */
		
		// Si le mot n'est pas dans la liste, renvoie undefined
		WordRule wr = new WordRule(new ToolboxWordDetector(), undefined);

		// Ajout des mots cles (noms des plugins)
		for(int i = 0 ; i < toolCodes.length ; ++i) {
			wr.addWord(toolCodes[i], keywordcode);
			// Cas des majuscules
			wr.addWord(toolCodes[i].toUpperCase(), keywordcode);
		}
		
		// Ajout des mots cles (begin et end)
		for(int i = 0 ; i < reserved.length ; ++i) {
			wr.addWord(reserved[i], reservedcode);
			// Cas des majuscules
			wr.addWord(reserved[i].toUpperCase(), reservedcode);
		}
		
		rules.add(wr);
		
		// Conversion de la List en tableau pour la passer à la méthode setRules
		IRule[] param = new IRule[rules.size()];
		rules.toArray(param);
		setRules(param);
	}
}
