package toolbox.editors;

import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;

import toolbox.Activator;

/**
 * Classe participant a l'initialisation du document
 */
@SuppressWarnings("deprecation")
public class ToolboxDocumentSetupParticipant implements IDocumentSetupParticipant {

	public void setup(IDocument document) {
		// Notion de partitionnements multiples
		if(document instanceof IDocumentExtension3)
		{
			IDocumentExtension3 extension3= (IDocumentExtension3) document;
			IDocumentPartitioner partitioner= new DefaultPartitioner(Activator.getDefault().getToolboxPartitionScanner(), ToolboxPartitionScanner.TOOLBOX_PARTITION_TYPES);
			
			extension3.setDocumentPartitioner(Activator.TOOLBOX_PARTITIONING, partitioner);
			
			partitioner.connect(document);
		}

	}

}
