package toolbox.editors;

import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;

public class ToolboxPartitionScanner extends RuleBasedPartitionScanner {
	// Identifiant des la partition des commentaires (valeur : "__toolbox_comment")
	public final static String TOOLBOX_COMMENT = "__toolbox_comment";
	
	// Tableau contenant tous les types de partitions possibles
	public final static String[] TOOLBOX_PARTITION_TYPES = new String[] {TOOLBOX_COMMENT};

	/**
	 * Constructeur par défaut. Positionne les différentes règles.
	 */
	public ToolboxPartitionScanner() {
		super();

		// Token renvoye dans le cas d'un commentaire
		IToken toolboxComment = new Token(TOOLBOX_COMMENT);
		
		// Regle pour les commentaires
		IPredicateRule[] rules = new IPredicateRule[] {new EndOfLineRule("//", toolboxComment)};
		
		// Prend en compte les regles
		setPredicateRules(rules);
	}

}
