package toolbox.editors;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ToolboxTextAttributeProvider {
	public static final String COMMENT_ATTRIBUTE = "__toolbox_comment_attribute";
	public static final String KEYWORD_ATTRIBUTE = "__toolbox_keyword_attribute";
	public static final String RESERVED_ATTRIBUTE = "__toolbox_reserved_attribute";
	public static final String DEFAULT_ATTRIBUTE = "__toolbox_default_attribute";
	private Map<String, TextAttribute> fAttributes = new HashMap<String, TextAttribute>();
	
	public ToolboxTextAttributeProvider() {
		// Les commentaires en vert
		fAttributes.put(COMMENT_ATTRIBUTE,new TextAttribute(new Color(Display.getCurrent(),new RGB(128, 128, 0))));
		
		// Les mots cles en bleu
		fAttributes.put(KEYWORD_ATTRIBUTE,new TextAttribute(new Color(Display.getCurrent(),new RGB(0, 0, 255)), null, SWT.ITALIC));
		
		// begin et end en bordeaux
		fAttributes.put(RESERVED_ATTRIBUTE,new TextAttribute(new Color(Display.getCurrent(),new RGB(129, 6, 88))));
		
		// Par defaut en noir
		fAttributes.put(DEFAULT_ATTRIBUTE,new TextAttribute(new Color(Display.getCurrent(),new RGB(0, 0, 0))));
	}
	
	public TextAttribute getAttribute(String type) {
		TextAttribute attr = (TextAttribute)fAttributes.get(type);
		if(attr == null) {
			attr = (TextAttribute) fAttributes.get(DEFAULT_ATTRIBUTE);
		}
		return attr;
	}
}
