/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.animate;

import java.util.Iterator;
import prefuse.action.ItemAction;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ColorLib;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.StartVisiblePredicate;

public class AxisLabelAnimator
extends ItemAction {
    protected AxisLabelAnimator() {
    }

    public AxisLabelAnimator(String string) {
        super(string);
    }

    public void run(double d) {
        if (d == 0.0) {
            this.setup();
        } else if (d == 1.0) {
            this.finish();
        } else {
            super.run(d);
        }
        TupleSet tupleSet = this.m_vis.getGroup(this.m_group);
        tupleSet.putClientProperty("frac", new Double(d));
    }

    private void setup() {
        int n;
        int n2;
        int n3;
        VisualItem visualItem;
        Iterator iterator = this.m_vis.visibleItems(this.m_group);
        while (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            if (!visualItem.isStartVisible()) {
                n3 = visualItem.getEndFillColor();
                n2 = visualItem.getEndStrokeColor();
                n = visualItem.getEndTextColor();
                visualItem.setStartFillColor(ColorLib.setAlpha(n3, 0));
                visualItem.setStartStrokeColor(ColorLib.setAlpha(n2, 0));
                visualItem.setStartTextColor(ColorLib.setAlpha(n, 0));
                visualItem.setStartVisible(true);
            }
            this.process(visualItem, 0.0);
        }
        iterator = this.m_vis.items(this.m_group, StartVisiblePredicate.TRUE);
        while (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            if (visualItem.isEndVisible()) continue;
            n3 = visualItem.getStartFillColor();
            n2 = visualItem.getStartStrokeColor();
            n = visualItem.getStartTextColor();
            visualItem.setEndFillColor(ColorLib.setAlpha(n3, 0));
            visualItem.setEndStrokeColor(ColorLib.setAlpha(n2, 0));
            visualItem.setEndTextColor(ColorLib.setAlpha(n, 0));
            visualItem.setVisible(true);
            this.process(visualItem, 0.0);
        }
    }

    private void finish() {
        VisualItem visualItem;
        Iterator iterator = this.m_vis.items(this.m_group, StartVisiblePredicate.TRUE);
        while (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            if (visualItem.isEndVisible()) continue;
            visualItem.setVisible(false);
            visualItem.setStartVisible(false);
        }
        iterator = this.m_vis.visibleItems(this.m_group);
        while (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            this.process(visualItem, 1.0);
            visualItem.setStartFillColor(visualItem.getEndFillColor());
            visualItem.setStartTextColor(visualItem.getEndTextColor());
            visualItem.setStartStrokeColor(visualItem.getEndStrokeColor());
        }
    }

    public void process(VisualItem visualItem, double d) {
        double d2 = visualItem.getStartX();
        visualItem.setX(d2 + d * (visualItem.getEndX() - d2));
        d2 = visualItem.getStartY();
        visualItem.setY(d2 + d * (visualItem.getEndY() - d2));
        d2 = visualItem.getDouble(VisualItem.STARTX2);
        d2 += d * (visualItem.getDouble(VisualItem.ENDX2) - d2);
        visualItem.setDouble(VisualItem.X2, d2);
        d2 = visualItem.getDouble(VisualItem.STARTY2);
        d2 += d * (visualItem.getDouble(VisualItem.ENDY2) - d2);
        visualItem.setDouble(VisualItem.Y2, d2);
        int n = ColorLib.interp(visualItem.getStartStrokeColor(), visualItem.getEndStrokeColor(), d);
        visualItem.setStrokeColor(n);
        int n2 = ColorLib.interp(visualItem.getStartTextColor(), visualItem.getEndTextColor(), d);
        visualItem.setTextColor(n2);
        int n3 = ColorLib.interp(visualItem.getStartFillColor(), visualItem.getEndFillColor(), d);
        visualItem.setFillColor(n3);
    }
}

