/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.StartVisiblePredicate;

public class CollapsedSubtreeLayout
extends Layout {
    private int m_orientation;
    private Point2D m_point = new Point2D.Double();

    public CollapsedSubtreeLayout(String string) {
        this(string, 4);
    }

    public CollapsedSubtreeLayout(String string, int n) {
        super(string);
        this.m_orientation = n;
    }

    public int getOrientation() {
        return this.m_orientation;
    }

    public void setOrientation(int n) {
        if (n < 0 || n >= 5) {
            throw new IllegalArgumentException("Unrecognized orientation value: " + n);
        }
        this.m_orientation = n;
    }

    public void run(double d) {
        Point2D point2D;
        NodeItem nodeItem;
        VisualItem visualItem;
        Iterator iterator = this.m_vis.visibleItems(this.m_group);
        while (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            if (!(visualItem instanceof NodeItem) || visualItem.isStartVisible()) continue;
            nodeItem = (NodeItem)visualItem;
            point2D = this.getPoint(nodeItem, true);
            nodeItem.setStartX(point2D.getX());
            nodeItem.setStartY(point2D.getY());
        }
        iterator = this.m_vis.items(this.m_group, StartVisiblePredicate.TRUE);
        while (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            if (!(visualItem instanceof NodeItem) || visualItem.isEndVisible()) continue;
            nodeItem = (NodeItem)visualItem;
            point2D = this.getPoint(nodeItem, false);
            nodeItem.setStartX(nodeItem.getEndX());
            nodeItem.setStartY(nodeItem.getEndY());
            nodeItem.setEndX(point2D.getX());
            nodeItem.setEndY(point2D.getY());
        }
    }

    private Point2D getPoint(NodeItem nodeItem, boolean bl) {
        NodeItem nodeItem2;
        if (bl) {
            for (nodeItem2 = (NodeItem)nodeItem.getParent(); nodeItem2 != null && !nodeItem2.isStartVisible(); nodeItem2 = (NodeItem)nodeItem2.getParent()) {
            }
        } else {
            while (nodeItem2 != null && !nodeItem2.isEndVisible()) {
                nodeItem2 = (NodeItem)nodeItem2.getParent();
            }
        }
        if (nodeItem2 == null) {
            this.m_point.setLocation(nodeItem.getX(), nodeItem.getY());
            return this.m_point;
        }
        double d = bl ? nodeItem2.getStartX() : nodeItem2.getEndX();
        double d2 = bl ? nodeItem2.getStartY() : nodeItem2.getEndY();
        Rectangle2D rectangle2D = nodeItem2.getBounds();
        switch (this.m_orientation) {
            case 0: {
                this.m_point.setLocation(d + rectangle2D.getWidth(), d2);
                break;
            }
            case 1: {
                this.m_point.setLocation(d - rectangle2D.getWidth(), d2);
                break;
            }
            case 2: {
                this.m_point.setLocation(d, d2 + rectangle2D.getHeight());
                break;
            }
            case 3: {
                this.m_point.setLocation(d, d2 - rectangle2D.getHeight());
                break;
            }
            case 4: {
                this.m_point.setLocation(d, d2);
            }
        }
        return this.m_point;
    }
}

