/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.column.Column;
import prefuse.data.column.ColumnFactory;
import prefuse.data.column.ColumnMetadata;
import prefuse.data.event.ColumnListener;
import prefuse.data.event.TableListener;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.tuple.AbstractTupleSet;
import prefuse.data.tuple.TableTuple;
import prefuse.data.tuple.TupleManager;
import prefuse.data.util.FilterIteratorFactory;
import prefuse.data.util.Index;
import prefuse.data.util.RowManager;
import prefuse.data.util.Sort;
import prefuse.data.util.TableIterator;
import prefuse.data.util.TreeIndex;
import prefuse.util.TypeLib;
import prefuse.util.collections.CopyOnWriteArrayList;
import prefuse.util.collections.IncompatibleComparatorException;
import prefuse.util.collections.IntIterator;

public class Table
extends AbstractTupleSet
implements ColumnListener {
    protected CopyOnWriteArrayList m_listeners = new CopyOnWriteArrayList();
    protected ArrayList m_columns;
    protected ArrayList m_names;
    protected HashMap m_entries;
    protected RowManager m_rows;
    protected TupleManager m_tuples;
    protected int m_modCount = 0;
    protected int m_lastCol = -1;
    protected Schema m_schema;

    public Table() {
        this(0, 0);
    }

    public Table(int n, int n2) {
        this(n, n2, TableTuple.class);
    }

    protected Table(int n, int n2, Class clazz) {
        this.m_columns = new ArrayList(n2);
        this.m_names = new ArrayList(n2);
        this.m_rows = new RowManager(this);
        this.m_entries = new HashMap(n2 + 5);
        this.m_tuples = new TupleManager(this, null, clazz);
        if (n > 0) {
            this.addRows(n);
        }
    }

    public int getColumnCount() {
        return this.m_columns.size();
    }

    public Class getColumnType(int n) {
        return this.getColumn(n).getColumnType();
    }

    public Class getColumnType(String string) {
        Column column = this.getColumn(string);
        return column == null ? null : column.getColumnType();
    }

    public int getRowCount() {
        return this.m_rows.getRowCount();
    }

    public int getMinimumRow() {
        return this.m_rows.getMinimumRow();
    }

    public int getMaximumRow() {
        return this.m_rows.getMaximumRow();
    }

    public boolean isCellEditable(int n, int n2) {
        if (!this.m_rows.isValidRow(n)) {
            return false;
        }
        return this.getColumn(n2).isCellEditable(n);
    }

    public int getModificationCount() {
        return this.m_modCount;
    }

    public void setTupleManager(TupleManager tupleManager) {
        this.m_tuples.invalidateAll();
        this.m_tuples = tupleManager;
    }

    public Schema getSchema() {
        if (this.m_schema == null) {
            Schema schema = new Schema();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                schema.addColumn(this.getColumnName(i), this.getColumnType(i), this.getColumn(i).getDefaultValue());
            }
            schema.lockSchema();
            this.m_schema = schema;
        }
        return this.m_schema;
    }

    protected void invalidateSchema() {
        this.m_schema = null;
    }

    public int getColumnRow(int n, int n2) {
        return this.m_rows.getColumnRow(n, n2);
    }

    public int getTableRow(int n, int n2) {
        return this.m_rows.getTableRow(n, n2);
    }

    public int addRow() {
        int n = this.m_rows.addRow();
        this.updateRowCount();
        this.fireTableEvent(n, n, -1, 1);
        return n;
    }

    public void addRows(int n) {
        for (int i = 0; i < n; ++i) {
            this.addRow();
        }
    }

    protected void updateRowCount() {
        int n = this.m_rows.getMaximumRow() + 1;
        Iterator iterator = this.getColumns();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            column.setMaximumRow(n);
        }
    }

    public boolean removeRow(int n) {
        if (this.m_rows.isValidRow(n)) {
            this.fireTableEvent(n, n, -1, -1);
            this.m_tuples.invalidate(n);
            this.m_rows.releaseRow(n);
            Iterator iterator = this.getColumns();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                column.revertToDefault(n);
            }
            return true;
        }
        return false;
    }

    public void clear() {
        IntIterator intIterator = this.rows(true);
        while (intIterator.hasNext()) {
            this.removeRow(intIterator.nextInt());
        }
    }

    public boolean isValidRow(int n) {
        return this.m_rows.isValidRow(n);
    }

    protected boolean hasColumn(String string) {
        return this.getColumnNumber(string) != -1;
    }

    public String getColumnName(int n) {
        return (String)this.m_names.get(n);
    }

    public int getColumnNumber(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        return columnEntry == null ? -1 : columnEntry.colnum;
    }

    public int getColumnNumber(Column column) {
        return this.m_columns.indexOf(column);
    }

    public Column getColumn(int n) {
        this.m_lastCol = n;
        return (Column)this.m_columns.get(n);
    }

    public Column getColumn(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        return columnEntry != null ? columnEntry.column : null;
    }

    public void addColumn(String string, Class clazz) {
        this.addColumn(string, clazz, null);
    }

    public void addColumn(String string, Class clazz, Object object) {
        Column column = ColumnFactory.getColumn(clazz, this.m_rows.getMaximumRow() + 1, object);
        this.addColumn(string, column);
    }

    public void addColumn(String string, String string2) {
        Expression expression = ExpressionParser.parse(string2);
        Throwable throwable = ExpressionParser.getError();
        if (throwable != null) {
            throw new RuntimeException(throwable);
        }
        this.addColumn(string, expression);
    }

    public void addColumn(String string, Expression expression) {
        this.addColumn(string, ColumnFactory.getColumn(this, expression));
    }

    public void addConstantColumn(String string, Class clazz, Object object) {
        this.addColumn(string, ColumnFactory.getConstantColumn(clazz, object));
    }

    protected void addColumn(String string, Column column) {
        int n = this.getColumnNumber(string);
        if (n >= 0 && n < this.m_columns.size()) {
            throw new IllegalArgumentException("Table already has column with name \"" + string + "\"");
        }
        this.m_columns.add(column);
        this.m_names.add(string);
        this.m_lastCol = this.m_columns.size() - 1;
        ColumnEntry columnEntry = new ColumnEntry(this.m_lastCol, column, new ColumnMetadata(this, string));
        ColumnEntry columnEntry2 = this.m_entries.put(string, columnEntry);
        if (columnEntry2 != null) {
            columnEntry2.dispose();
        }
        this.invalidateSchema();
        column.addColumnListener(this);
        this.fireTableEvent(this.m_rows.getMinimumRow(), this.m_rows.getMaximumRow(), this.m_lastCol, 1);
    }

    protected Column removeColumn(int n) {
        if (n < 0 || n >= this.m_columns.size()) {
            throw new IllegalArgumentException("Column index is not legal.");
        }
        String string = (String)this.m_names.get(n);
        ((ColumnEntry)this.m_entries.get(string)).dispose();
        Column column = (Column)this.m_columns.remove(n);
        this.m_entries.remove(string);
        this.m_names.remove(n);
        this.renumberColumns();
        this.m_lastCol = -1;
        this.invalidateSchema();
        column.removeColumnListener(this);
        this.fireTableEvent(this.m_rows.getMinimumRow(), this.m_rows.getMaximumRow(), n, -1);
        return column;
    }

    public Column removeColumn(String string) {
        int n = this.m_names.indexOf(string);
        if (n < 0) {
            throw new IllegalArgumentException("No such column.");
        }
        return this.removeColumn(n);
    }

    public void removeColumn(Column column) {
        int n = this.m_columns.indexOf(column);
        if (n < 0) {
            throw new IllegalArgumentException("No such column.");
        }
        this.removeColumn(n);
    }

    protected void renumberColumns() {
        Iterator iterator = this.m_names.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
            columnEntry.colnum = n++;
        }
    }

    protected Iterator getColumns() {
        return this.m_columns.iterator();
    }

    protected Iterator getColumnNames() {
        return this.m_names.iterator();
    }

    public ColumnMetadata getMetadata(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        if (columnEntry == null) {
            throw new IllegalArgumentException("Unknown column name: " + string);
        }
        return columnEntry.metadata;
    }

    public Index index(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        if (columnEntry == null) {
            throw new IllegalArgumentException("Unknown column name: " + string);
        }
        if (columnEntry.index != null) {
            return columnEntry.index;
        }
        Column column = columnEntry.column;
        try {
            columnEntry.index = new TreeIndex(this, this.m_rows, column, null);
        }
        catch (IncompatibleComparatorException incompatibleComparatorException) {
            // empty catch block
        }
        return columnEntry.index;
    }

    public Index getIndex(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        if (columnEntry == null) {
            throw new IllegalArgumentException("Unknown column name: " + string);
        }
        return columnEntry.index;
    }

    protected Index getIndex(String string, Class clazz, boolean bl) {
        if (!clazz.equals(this.getColumnType(string))) {
            throw new IllegalArgumentException("Column type does not match.");
        }
        if (this.getIndex(string) == null && bl) {
            this.index(string);
        }
        return this.getIndex(string);
    }

    public boolean removeIndex(String string) {
        ColumnEntry columnEntry = (ColumnEntry)this.m_entries.get(string);
        if (columnEntry == null) {
            throw new IllegalArgumentException("Unknown column name: " + string);
        }
        if (columnEntry.index == null) {
            return false;
        }
        columnEntry.index.dispose();
        columnEntry.index = null;
        return true;
    }

    public Tuple getTuple(int n) {
        return this.m_tuples.getTuple(n);
    }

    public Tuple addTuple(Tuple tuple) {
        if (tuple.getTable() == this) {
            return null;
        }
        Schema schema = tuple.getSchema();
        if (this.getSchema().isAssignableFrom(schema)) {
            int n = this.addRow();
            for (int i = 0; i < schema.getColumnCount(); ++i) {
                String string = schema.getColumnName(i);
                this.set(n, string, tuple.get(i));
            }
            return this.getTuple(n);
        }
        return null;
    }

    public Tuple setTuple(Tuple tuple) {
        this.clear();
        return this.addTuple(tuple);
    }

    public boolean removeTuple(Tuple tuple) {
        if (this.containsTuple(tuple)) {
            this.removeRow(tuple.getRow());
            return true;
        }
        return false;
    }

    public boolean containsTuple(Tuple tuple) {
        return tuple.getTable() == this && this.isValidRow(tuple.getRow());
    }

    public int getTupleCount() {
        return this.getRowCount();
    }

    public boolean isAddColumnSupported() {
        return true;
    }

    public boolean canGet(String string, Class clazz) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGet(clazz);
    }

    public boolean canSet(String string, Class clazz) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSet(clazz);
    }

    public Object get(int n, String string) {
        int n2 = this.getColumnNumber(string);
        n = this.getColumnRow(n, n2);
        return this.getColumn(n2).get(n);
    }

    public void set(int n, String string, Object object) {
        int n2 = this.getColumnNumber(string);
        n = this.getColumnRow(n, n2);
        this.getColumn(n2).set(object, n);
    }

    public Object get(int n, int n2) {
        n = this.getColumnRow(n, n2);
        return this.getColumn(n2).get(n);
    }

    public void set(int n, int n2, Object object) {
        n = this.getColumnRow(n, n2);
        this.getColumn(n2).set(object, n);
    }

    public Object getDefault(String string) {
        int n = this.getColumnNumber(string);
        return this.getColumn(n).getDefaultValue();
    }

    public void revertToDefault(int n, String string) {
        int n2 = this.getColumnNumber(string);
        n = this.getColumnRow(n, n2);
        this.getColumn(n2).revertToDefault(n);
    }

    public final boolean canGetInt(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetInt();
    }

    public final boolean canSetInt(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetInt();
    }

    public final int getInt(int n, String string) {
        int n2 = this.getColumnNumber(string);
        n = this.getColumnRow(n, n2);
        return this.getColumn(n2).getInt(n);
    }

    public final void setInt(int n, String string, int n2) {
        int n3 = this.getColumnNumber(string);
        n = this.getColumnRow(n, n3);
        this.getColumn(n3).setInt(n2, n);
    }

    public final int getInt(int n, int n2) {
        n = this.getColumnRow(n, n2);
        return this.getColumn(n2).getInt(n);
    }

    public final void setInt(int n, int n2, int n3) {
        n = this.getColumnRow(n, n2);
        this.getColumn(n2).setInt(n3, n);
    }

    public final boolean canGetLong(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetLong();
    }

    public final boolean canSetLong(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetLong();
    }

    public final long getLong(int n, String string) {
        int n2 = this.getColumnNumber(string);
        n = this.getColumnRow(n, n2);
        return this.getColumn(n2).getLong(n);
    }

    public final void setLong(int n, String string, long l) {
        int n2 = this.getColumnNumber(string);
        n = this.getColumnRow(n, n2);
        this.getColumn(n2).setLong(l, n);
    }

    public final long getLong(int n, int n2) {
        n = this.getColumnRow(n, n2);
        return this.getColumn(n2).getLong(n);
    }

    public final void setLong(int n, int n2, long l) {
        n = this.getColumnRow(n, n2);
        this.getColumn(n2).setLong(l, n);
    }

    public final boolean canGetFloat(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetFloat();
    }

    public final boolean canSetFloat(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetFloat();
    }

    public final float getFloat(int n, String string) {
        int n2 = this.getColumnNumber(string);
        n = this.getColumnRow(n, n2);
        return this.getColumn(n2).getFloat(n);
    }

    public final void setFloat(int n, String string, float f) {
        int n2 = this.getColumnNumber(string);
        n = this.getColumnRow(n, n2);
        this.getColumn(n2).setFloat(f, n);
    }

    public final float getFloat(int n, int n2) {
        n = this.getColumnRow(n, n2);
        return this.getColumn(n2).getFloat(n);
    }

    public final void setFloat(int n, int n2, float f) {
        n = this.getColumnRow(n, n2);
        this.getColumn(n2).setFloat(f, n);
    }

    public final boolean canGetDouble(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetDouble();
    }

    public final boolean canSetDouble(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetDouble();
    }

    public final double getDouble(int n, String string) {
        int n2 = this.getColumnNumber(string);
        n = this.getColumnRow(n, n2);
        return this.getColumn(n2).getDouble(n);
    }

    public final void setDouble(int n, String string, double d) {
        int n2 = this.getColumnNumber(string);
        n = this.getColumnRow(n, n2);
        this.getColumn(n2).setDouble(d, n);
    }

    public final double getDouble(int n, int n2) {
        n = this.getColumnRow(n, n2);
        return this.getColumn(n2).getDouble(n);
    }

    public final void setDouble(int n, int n2, double d) {
        n = this.getColumnRow(n, n2);
        this.getColumn(n2).setDouble(d, n);
    }

    public final boolean canGetBoolean(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetBoolean();
    }

    public final boolean canSetBoolean(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetBoolean();
    }

    public final boolean getBoolean(int n, String string) {
        int n2 = this.getColumnNumber(string);
        n = this.getColumnRow(n, n2);
        return this.getColumn(n2).getBoolean(n);
    }

    public final void setBoolean(int n, String string, boolean bl) {
        int n2 = this.getColumnNumber(string);
        n = this.getColumnRow(n, n2);
        this.getColumn(n2).setBoolean(bl, n);
    }

    public final boolean getBoolean(int n, int n2) {
        n = this.getColumnRow(n, n2);
        return this.getColumn(n2).getBoolean(n);
    }

    public final void setBoolean(int n, int n2, boolean bl) {
        n = this.getColumnRow(n, n2);
        this.getColumn(n2).setBoolean(bl, n);
    }

    public final boolean canGetString(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetString();
    }

    public final boolean canSetString(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetString();
    }

    public final String getString(int n, String string) {
        int n2 = this.getColumnNumber(string);
        n = this.getColumnRow(n, n2);
        return this.getColumn(n2).getString(n);
    }

    public final void setString(int n, String string, String string2) {
        int n2 = this.getColumnNumber(string);
        n = this.getColumnRow(n, n2);
        this.getColumn(n2).setString(string2, n);
    }

    public final String getString(int n, int n2) {
        n = this.getColumnRow(n, n2);
        return this.getColumn(n2).getString(n);
    }

    public final void setString(int n, int n2, String string) {
        n = this.getColumnRow(n, n2);
        this.getColumn(n2).setString(string, n);
    }

    public final boolean canGetDate(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canGetDate();
    }

    public final boolean canSetDate(String string) {
        Column column = this.getColumn(string);
        return column == null ? false : column.canSetDate();
    }

    public final Date getDate(int n, String string) {
        int n2 = this.getColumnNumber(string);
        n = this.getColumnRow(n, n2);
        return this.getColumn(n2).getDate(n);
    }

    public final void setDate(int n, String string, Date date) {
        int n2 = this.getColumnNumber(string);
        n = this.getColumnRow(n, n2);
        this.getColumn(n2).setDate(date, n);
    }

    public final Date getDate(int n, int n2) {
        n = this.getColumnRow(n, n2);
        return this.getColumn(n2).getDate(n);
    }

    public final void setDate(int n, int n2, Date date) {
        n = this.getColumnRow(n, n2);
        this.getColumn(n2).setDate(date, n);
    }

    public Table select(Predicate predicate, Sort sort) {
        Table table = this.getSchema().instantiate();
        Iterator iterator = this.tuples(predicate, sort);
        while (iterator.hasNext()) {
            table.addTuple((Tuple)iterator.next());
        }
        return table;
    }

    public void remove(Predicate predicate) {
        IntIterator intIterator = this.rows(predicate);
        while (intIterator.hasNext()) {
            this.removeRow(intIterator.nextInt());
        }
    }

    public TableIterator iterator() {
        return this.iterator(this.rows());
    }

    public TableIterator iterator(IntIterator intIterator) {
        return new TableIterator(this, intIterator);
    }

    public Iterator tuples() {
        return this.m_tuples.iterator(this.rows());
    }

    public Iterator tuplesReversed() {
        return this.m_tuples.iterator(this.rows(true));
    }

    public Iterator tuples(IntIterator intIterator) {
        return this.m_tuples.iterator(intIterator);
    }

    public IntIterator rows() {
        return this.m_rows.rows();
    }

    public IntIterator rows(Predicate predicate) {
        return FilterIteratorFactory.rows(this, predicate);
    }

    public IntIterator rows(boolean bl) {
        return this.m_rows.rows(bl);
    }

    public IntIterator rowsSortedBy(String string, boolean bl) {
        Class clazz = this.getColumnType(string);
        Index index = this.getIndex(string, clazz, true);
        int n = bl ? 32 : 16;
        return index.allRows(n);
    }

    public IntIterator rangeSortedBy(String string, int n, int n2, int n3) {
        Index index = this.getIndex(string, Integer.TYPE, true);
        return index.rows(n, n2, n3);
    }

    public IntIterator rangeSortedBy(String string, long l, long l2, int n) {
        Index index = this.getIndex(string, Long.TYPE, true);
        return index.rows(l, l2, n);
    }

    public IntIterator rangeSortedBy(String string, float f, float f2, int n) {
        Index index = this.getIndex(string, Float.TYPE, true);
        return index.rows(f, f2, n);
    }

    public IntIterator rangeSortedBy(String string, double d, double d2, int n) {
        Index index = this.getIndex(string, Double.TYPE, true);
        return index.rows(d, d2, n);
    }

    public IntIterator rangeSortedBy(String string, Object object, Object object2, int n) {
        Class clazz = TypeLib.getSharedType(object, object2);
        if (clazz == null) {
            throw new IllegalArgumentException("Incompatible arguments");
        }
        Index index = this.getIndex(string, clazz, true);
        return index.rows(object, object2, n);
    }

    public void columnChanged(Column column, int n, boolean bl) {
        this.handleColumnChanged(column, n, n);
    }

    public void columnChanged(Column column, int n, double d) {
        this.handleColumnChanged(column, n, n);
    }

    public void columnChanged(Column column, int n, float f) {
        this.handleColumnChanged(column, n, n);
    }

    public void columnChanged(Column column, int n, int n2) {
        this.handleColumnChanged(column, n, n);
    }

    public void columnChanged(Column column, int n, long l) {
        this.handleColumnChanged(column, n, n);
    }

    public void columnChanged(Column column, int n, Object object) {
        this.handleColumnChanged(column, n, n);
    }

    public void columnChanged(Column column, int n, int n2, int n3) {
        this.handleColumnChanged(column, n2, n3);
    }

    protected void handleColumnChanged(Column column, int n, int n2) {
        while (!this.isValidRow(n) && n <= n2) {
            ++n;
        }
        if (n > n2) {
            return;
        }
        int n3 = this.m_lastCol != -1 && column == this.getColumn(this.m_lastCol) ? this.m_lastCol : this.getColumnNumber(column);
        if (n3 >= 0) {
            this.fireTableEvent(n, n2, n3, 0);
        }
    }

    public void addTableListener(TableListener tableListener) {
        if (!this.m_listeners.contains(tableListener)) {
            this.m_listeners.add(tableListener);
        }
    }

    public void removeTableListener(TableListener tableListener) {
        this.m_listeners.remove(tableListener);
    }

    public void removeAllTableListeners() {
        this.m_listeners.clear();
    }

    protected void fireTableEvent(int n, int n2, int n3, int n4) {
        ++this.m_modCount;
        if (n4 != 0 && n3 == -1) {
            this.fireTupleEvent(this, n, n2, n4);
        }
        if (!this.m_listeners.isEmpty()) {
            Object[] objectArray = this.m_listeners.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TableListener)objectArray[i]).tableChanged(this, n, n2, n3, n4);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Table[");
        stringBuffer.append("rows=").append(this.getRowCount());
        stringBuffer.append(", cols=").append(this.getColumnCount());
        stringBuffer.append(", maxrow=").append(this.m_rows.getMaximumRow());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected static class ColumnEntry {
        public int colnum;
        public Column column;
        public ColumnMetadata metadata;
        public Index index;

        public ColumnEntry(int n, Column column, ColumnMetadata columnMetadata) {
            this.colnum = n;
            this.column = column;
            this.metadata = columnMetadata;
            this.index = null;
        }

        public void dispose() {
            if (this.metadata != null) {
                this.metadata.dispose();
            }
            if (this.index != null) {
                this.index.dispose();
            }
        }
    }
}

