/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import java.util.logging.Logger;
import prefuse.data.expression.AndPredicate;
import prefuse.data.expression.ArithmeticExpression;
import prefuse.data.expression.BooleanLiteral;
import prefuse.data.expression.ColumnExpression;
import prefuse.data.expression.ComparisonPredicate;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Function;
import prefuse.data.expression.FunctionTable;
import prefuse.data.expression.IfExpression;
import prefuse.data.expression.NotPredicate;
import prefuse.data.expression.NumericLiteral;
import prefuse.data.expression.ObjectLiteral;
import prefuse.data.expression.OrPredicate;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.XorPredicate;
import prefuse.data.expression.parser.ExpressionParserConstants;
import prefuse.data.expression.parser.ExpressionParserTokenManager;
import prefuse.data.expression.parser.JavaCharStream;
import prefuse.data.expression.parser.ParseException;
import prefuse.data.expression.parser.Token;
import prefuse.util.StringLib;

public class ExpressionParser
implements ExpressionParserConstants {
    private static final Logger s_logger = Logger.getLogger(ExpressionParser.class.getName());
    private static boolean s_init = false;
    private static Throwable s_error;
    private static boolean jj_initialized_once;
    public static ExpressionParserTokenManager token_source;
    static JavaCharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_ntk;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static Vector jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;

    public static synchronized Expression parse(String string, boolean bl) {
        if (!s_init) {
            new ExpressionParser(new StringReader(string));
            s_init = true;
        } else {
            ExpressionParser.ReInit(new StringReader(string));
        }
        try {
            Expression expression = ExpressionParser.Parse();
            s_error = null;
            s_logger.info("Parsed Expression: " + expression);
            return expression;
        }
        catch (ParseException parseException) {
            s_error = parseException;
            if (bl) {
                throw parseException;
            }
            s_logger.warning("Expression Parse Error: " + parseException.getMessage() + "\n" + StringLib.getStackTrace(parseException));
            return null;
        }
    }

    public static synchronized Expression parse(String string) {
        return ExpressionParser.parse(string, false);
    }

    public static synchronized Predicate predicate(String string) {
        Expression expression = ExpressionParser.parse(string, false);
        if (expression == null) {
            return null;
        }
        if (expression instanceof Predicate) {
            return (Predicate)expression;
        }
        s_error = new ClassCastException("Expression is not a predicate");
        return null;
    }

    public static synchronized Throwable getError() {
        return s_error;
    }

    private static String unescape(String string) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        String string2 = "tnrbf\\\"'";
        String string3 = "\t\n\r\b\f\\\"'";
        StringBuffer stringBuffer = null;
        while ((n = string.indexOf(92, n3)) != -1) {
            if (stringBuffer != null) {
                stringBuffer.append(string.substring(n3, n));
            }
            if (n + 1 == n2) break;
            char c = string.charAt(n + 1);
            int n4 = string2.indexOf(c);
            if (n4 == -1) {
                stringBuffer.append('\\');
                stringBuffer.append(c);
            } else {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.substring(n3, n));
                }
                stringBuffer.append(string3.charAt(n4));
            }
            n3 = n + 2;
        }
        if (stringBuffer != null && n3 < n2) {
            stringBuffer.append(string.substring(n3));
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    public static final String Name() throws ParseException {
        Token token = ExpressionParser.jj_consume_token(26);
        return token.image;
    }

    public static final String Quoted() throws ParseException {
        Token token = ExpressionParser.jj_consume_token(25);
        return token.image.substring(1, token.image.length() - 1);
    }

    public static final Expression Parse() throws ParseException {
        switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 37: 
            case 38: {
                Expression expression = ExpressionParser.Expression();
                ExpressionParser.jj_consume_token(0);
                return expression;
            }
            case 0: {
                ExpressionParser.jj_consume_token(0);
                throw new ParseException("No expression provided");
            }
        }
        ExpressionParser.jj_la1[0] = jj_gen;
        ExpressionParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final Expression Expression() throws ParseException {
        Expression expression = ExpressionParser.OrExpression();
        return expression;
    }

    public static final Expression OrExpression() throws ParseException {
        Expression expression = ExpressionParser.XorExpression();
        block3: while (true) {
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 13: {
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[1] = jj_gen;
                    break block3;
                }
            }
            ExpressionParser.jj_consume_token(13);
            Expression expression2 = ExpressionParser.XorExpression();
            if (expression instanceof OrPredicate) {
                ((OrPredicate)expression).add((Predicate)expression2);
                continue;
            }
            expression = new OrPredicate((Predicate)expression, (Predicate)expression2);
        }
        return expression;
    }

    public static final Expression XorExpression() throws ParseException {
        Expression expression = ExpressionParser.AndExpression();
        block3: while (true) {
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 15: {
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[2] = jj_gen;
                    break block3;
                }
            }
            ExpressionParser.jj_consume_token(15);
            Expression expression2 = ExpressionParser.AndExpression();
            if (expression instanceof XorPredicate) {
                ((XorPredicate)expression).add((Predicate)expression2);
                continue;
            }
            expression = new XorPredicate((Predicate)expression, (Predicate)expression2);
        }
        return expression;
    }

    public static final Expression AndExpression() throws ParseException {
        Expression expression = ExpressionParser.EqualityExpression();
        block3: while (true) {
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[3] = jj_gen;
                    break block3;
                }
            }
            ExpressionParser.jj_consume_token(12);
            Expression expression2 = ExpressionParser.EqualityExpression();
            if (expression instanceof AndPredicate) {
                ((AndPredicate)expression).add((Predicate)expression2);
                continue;
            }
            expression = new AndPredicate((Predicate)expression, (Predicate)expression2);
        }
        return expression;
    }

    public static final Expression EqualityExpression() throws ParseException {
        Expression expression = ExpressionParser.RelationalExpression();
        block7: while (true) {
            Token token;
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 31: 
                case 36: {
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[4] = jj_gen;
                    break block7;
                }
            }
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 31: {
                    token = ExpressionParser.jj_consume_token(31);
                    break;
                }
                case 36: {
                    token = ExpressionParser.jj_consume_token(36);
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[5] = jj_gen;
                    ExpressionParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression expression2 = ExpressionParser.RelationalExpression();
            int n = token.kind == 31 ? 2 : 3;
            expression = new ComparisonPredicate(n, expression, expression2);
        }
        return expression;
    }

    public static final Expression RelationalExpression() throws ParseException {
        int n = -1;
        Expression expression = ExpressionParser.AdditiveExpression();
        block15: while (true) {
            Token token;
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[6] = jj_gen;
                    break block15;
                }
            }
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 33: {
                    token = ExpressionParser.jj_consume_token(33);
                    break;
                }
                case 32: {
                    token = ExpressionParser.jj_consume_token(32);
                    break;
                }
                case 34: {
                    token = ExpressionParser.jj_consume_token(34);
                    break;
                }
                case 35: {
                    token = ExpressionParser.jj_consume_token(35);
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[7] = jj_gen;
                    ExpressionParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression expression2 = ExpressionParser.AdditiveExpression();
            switch (token.kind) {
                case 33: {
                    n = 0;
                    break;
                }
                case 32: {
                    n = 1;
                    break;
                }
                case 34: {
                    n = 4;
                    break;
                }
                case 35: {
                    n = 5;
                }
            }
            expression = new ComparisonPredicate(n, expression, expression2);
        }
        return expression;
    }

    public static final Expression AdditiveExpression() throws ParseException {
        int n = -1;
        Expression expression = ExpressionParser.MultiplicativeExpression();
        block13: while (true) {
            Token token;
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 37: 
                case 38: 
                case 42: {
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[8] = jj_gen;
                    break block13;
                }
            }
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 37: {
                    token = ExpressionParser.jj_consume_token(37);
                    break;
                }
                case 38: {
                    token = ExpressionParser.jj_consume_token(38);
                    break;
                }
                case 42: {
                    token = ExpressionParser.jj_consume_token(42);
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[9] = jj_gen;
                    ExpressionParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression expression2 = ExpressionParser.MultiplicativeExpression();
            switch (token.kind) {
                case 37: {
                    n = 0;
                    break;
                }
                case 38: {
                    n = 1;
                    break;
                }
                case 42: {
                    n = 5;
                }
            }
            expression = new ArithmeticExpression(n, expression, expression2);
        }
        return expression;
    }

    public static final Expression MultiplicativeExpression() throws ParseException {
        int n = -1;
        Expression expression = ExpressionParser.UnaryExpression();
        block13: while (true) {
            Token token;
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 39: 
                case 40: 
                case 41: {
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[10] = jj_gen;
                    break block13;
                }
            }
            switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                case 39: {
                    token = ExpressionParser.jj_consume_token(39);
                    break;
                }
                case 40: {
                    token = ExpressionParser.jj_consume_token(40);
                    break;
                }
                case 41: {
                    token = ExpressionParser.jj_consume_token(41);
                    break;
                }
                default: {
                    ExpressionParser.jj_la1[11] = jj_gen;
                    ExpressionParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression expression2 = ExpressionParser.UnaryExpression();
            switch (token.kind) {
                case 39: {
                    n = 2;
                    break;
                }
                case 40: {
                    n = 3;
                    break;
                }
                case 41: {
                    n = 4;
                }
            }
            expression = new ArithmeticExpression(n, expression, expression2);
        }
        return expression;
    }

    public static final Expression UnaryExpression() throws ParseException {
        switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
            case 37: 
            case 38: {
                Token token;
                switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                    case 37: {
                        token = ExpressionParser.jj_consume_token(37);
                        break;
                    }
                    case 38: {
                        token = ExpressionParser.jj_consume_token(38);
                        break;
                    }
                    default: {
                        ExpressionParser.jj_la1[12] = jj_gen;
                        ExpressionParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Expression expression = ExpressionParser.UnaryExpression();
                if (token.kind == 38 && expression instanceof NumericLiteral) {
                    Number number = (Number)expression.get(null);
                    if (number instanceof Integer) {
                        return new NumericLiteral(-1 * number.intValue());
                    }
                    if (number instanceof Double) {
                        return new NumericLiteral(-1.0 * number.doubleValue());
                    }
                    if (number instanceof Long) {
                        return new NumericLiteral(-1L * number.longValue());
                    }
                    if (number instanceof Float) {
                        return new NumericLiteral(-1.0f * number.floatValue());
                    }
                    return new ArithmeticExpression(2, new NumericLiteral(-1), expression);
                }
                if (token.kind == 38) {
                    return new ArithmeticExpression(2, new NumericLiteral(-1), expression);
                }
                return expression;
            }
            case 14: {
                Expression expression = ExpressionParser.UnaryExpressionNotPlusMinus();
                return expression;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                Expression expression = ExpressionParser.PrimaryExpression();
                return expression;
            }
        }
        ExpressionParser.jj_la1[13] = jj_gen;
        ExpressionParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final Expression UnaryExpressionNotPlusMinus() throws ParseException {
        ExpressionParser.jj_consume_token(14);
        Expression expression = ExpressionParser.UnaryExpression();
        if (expression instanceof NotPredicate) {
            return ((NotPredicate)expression).getPredicate();
        }
        if (!(expression instanceof Predicate)) {
            throw new ParseException("Can't negate a non-predicate");
        }
        return new NotPredicate((Predicate)expression);
    }

    public static final Expression PrimaryExpression() throws ParseException {
        switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                Expression expression = ExpressionParser.Literal();
                return expression;
            }
            case 9: {
                Expression expression = ExpressionParser.IfStatement();
                return expression;
            }
            case 25: 
            case 26: {
                Expression expression = ExpressionParser.Identifier();
                return expression;
            }
            case 29: {
                ExpressionParser.jj_consume_token(29);
                Expression expression = ExpressionParser.Expression();
                ExpressionParser.jj_consume_token(30);
                return expression;
            }
        }
        ExpressionParser.jj_la1[14] = jj_gen;
        ExpressionParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final Expression Literal() throws ParseException {
        switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
            case 16: {
                Token token = ExpressionParser.jj_consume_token(16);
                return new NumericLiteral(Integer.parseInt(token.image));
            }
            case 20: {
                Token token = ExpressionParser.jj_consume_token(20);
                return new NumericLiteral(Long.parseLong(token.image.substring(0, token.image.length() - 1)));
            }
            case 22: {
                Token token = ExpressionParser.jj_consume_token(22);
                return new NumericLiteral(Float.parseFloat(token.image));
            }
            case 21: {
                Token token = ExpressionParser.jj_consume_token(21);
                return new NumericLiteral(Double.parseDouble(token.image));
            }
            case 24: {
                Token token = ExpressionParser.jj_consume_token(24);
                String string = ExpressionParser.unescape(token.image.substring(1, token.image.length() - 1));
                return new ObjectLiteral(string);
            }
            case 6: {
                ExpressionParser.jj_consume_token(6);
                return new BooleanLiteral(true);
            }
            case 7: {
                ExpressionParser.jj_consume_token(7);
                return new BooleanLiteral(false);
            }
            case 8: {
                ExpressionParser.jj_consume_token(8);
                return new ObjectLiteral(null);
            }
        }
        ExpressionParser.jj_la1[15] = jj_gen;
        ExpressionParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final Expression Identifier() throws ParseException {
        Function function = null;
        switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
            case 25: {
                String string = ExpressionParser.Quoted();
                return new ColumnExpression(string);
            }
            case 26: {
                String string = ExpressionParser.Name();
                switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                    case 29: {
                        ExpressionParser.jj_consume_token(29);
                        function = FunctionTable.createFunction(string);
                        block7 : switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 14: 
                            case 16: 
                            case 20: 
                            case 21: 
                            case 22: 
                            case 24: 
                            case 25: 
                            case 26: 
                            case 29: 
                            case 37: 
                            case 38: {
                                Expression expression = ExpressionParser.Expression();
                                function.addParameter(expression);
                                while (true) {
                                    switch (jj_ntk == -1 ? ExpressionParser.jj_ntk() : jj_ntk) {
                                        case 43: {
                                            break;
                                        }
                                        default: {
                                            ExpressionParser.jj_la1[16] = jj_gen;
                                            break block7;
                                        }
                                    }
                                    ExpressionParser.jj_consume_token(43);
                                    expression = ExpressionParser.Expression();
                                    function.addParameter(expression);
                                }
                            }
                            default: {
                                ExpressionParser.jj_la1[17] = jj_gen;
                            }
                        }
                        ExpressionParser.jj_consume_token(30);
                        break;
                    }
                    default: {
                        ExpressionParser.jj_la1[18] = jj_gen;
                    }
                }
                return function == null ? new ColumnExpression(string) : function;
            }
        }
        ExpressionParser.jj_la1[19] = jj_gen;
        ExpressionParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final Expression IfStatement() throws ParseException {
        ExpressionParser.jj_consume_token(9);
        Expression expression = ExpressionParser.Expression();
        ExpressionParser.jj_consume_token(10);
        Expression expression2 = ExpressionParser.Expression();
        ExpressionParser.jj_consume_token(11);
        Expression expression3 = ExpressionParser.Expression();
        if (!(expression instanceof Predicate)) {
            throw new ParseException("IF-statement test must be a predicate");
        }
        return new IfExpression((Predicate)expression, expression2, expression3);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{661734337, 8192, 32768, 4096, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 661734336, 661717952, 24183232, 0, 661734336, 0x20000000, 0x6000000};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{96, 0, 0, 0, 16, 16, 15, 15, 1120, 1120, 896, 896, 96, 96, 0, 0, 2048, 96, 0, 0};
    }

    public ExpressionParser(InputStream inputStream) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new JavaCharStream(inputStream, 1, 1);
        token_source = new ExpressionParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 20; ++i) {
            ExpressionParser.jj_la1[i] = -1;
        }
    }

    public static void ReInit(InputStream inputStream) {
        jj_input_stream.ReInit(inputStream, 1, 1);
        ExpressionParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 20; ++i) {
            ExpressionParser.jj_la1[i] = -1;
        }
    }

    public ExpressionParser(Reader reader) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new JavaCharStream(reader, 1, 1);
        token_source = new ExpressionParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 20; ++i) {
            ExpressionParser.jj_la1[i] = -1;
        }
    }

    public static void ReInit(Reader reader) {
        jj_input_stream.ReInit(reader, 1, 1);
        ExpressionParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 20; ++i) {
            ExpressionParser.jj_la1[i] = -1;
        }
    }

    public ExpressionParser(ExpressionParserTokenManager expressionParserTokenManager) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        token_source = expressionParserTokenManager;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 20; ++i) {
            ExpressionParser.jj_la1[i] = -1;
        }
    }

    public void ReInit(ExpressionParserTokenManager expressionParserTokenManager) {
        token_source = expressionParserTokenManager;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 20; ++i) {
            ExpressionParser.jj_la1[i] = -1;
        }
    }

    private static final Token jj_consume_token(int n) throws ParseException {
        Token token = ExpressionParser.token;
        ExpressionParser.token = token.next != null ? ExpressionParser.token.next : (ExpressionParser.token.next = ExpressionParserTokenManager.getNextToken());
        jj_ntk = -1;
        if (ExpressionParser.token.kind == n) {
            ++jj_gen;
            return ExpressionParser.token;
        }
        ExpressionParser.token = token;
        jj_kind = n;
        throw ExpressionParser.generateParseException();
    }

    public static final Token getNextToken() {
        token = ExpressionParser.token.next != null ? ExpressionParser.token.next : (ExpressionParser.token.next = ExpressionParserTokenManager.getNextToken());
        jj_ntk = -1;
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int n) {
        Token token = ExpressionParser.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = ExpressionParserTokenManager.getNextToken());
        }
        return token;
    }

    private static final int jj_ntk() {
        jj_nt = ExpressionParser.token.next;
        if (jj_nt == null) {
            ExpressionParser.token.next = ExpressionParserTokenManager.getNextToken();
            jj_ntk = ExpressionParser.token.next.kind;
            return jj_ntk;
        }
        jj_ntk = ExpressionParser.jj_nt.kind;
        return jj_ntk;
    }

    public static ParseException generateParseException() {
        int n;
        int n2;
        jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[44];
        for (n2 = 0; n2 < 44; ++n2) {
            blArray[n2] = false;
        }
        if (jj_kind >= 0) {
            blArray[ExpressionParser.jj_kind] = true;
            jj_kind = -1;
        }
        for (n2 = 0; n2 < 20; ++n2) {
            if (jj_la1[n2] != jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) == 0) continue;
                blArray[32 + n] = true;
            }
        }
        for (n2 = 0; n2 < 44; ++n2) {
            if (!blArray[n2]) continue;
            jj_expentry = new int[1];
            ExpressionParser.jj_expentry[0] = n2;
            jj_expentries.addElement(jj_expentry);
        }
        int[][] nArrayArray = new int[jj_expentries.size()][];
        for (n = 0; n < jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])jj_expentries.elementAt(n);
        }
        return new ParseException(token, nArrayArray, tokenImage);
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }

    static {
        jj_initialized_once = false;
        jj_la1 = new int[20];
        ExpressionParser.jj_la1_0();
        ExpressionParser.jj_la1_1();
        jj_expentries = new Vector();
        jj_kind = -1;
    }
}

