/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import prefuse.data.io.AbstractTextTableReader;
import prefuse.data.io.DataIOException;
import prefuse.data.io.FixedWidthTextTableSchema;
import prefuse.data.io.TableReadListener;
import prefuse.data.parser.DataParseException;

public class FixedWidthTextTableReader
extends AbstractTextTableReader {
    private FixedWidthTextTableSchema m_schema;

    public FixedWidthTextTableReader(FixedWidthTextTableSchema fixedWidthTextTableSchema) {
        super.setHasHeader(false);
        this.m_schema = fixedWidthTextTableSchema;
    }

    public FixedWidthTextTableReader(String string) throws DataIOException {
        this(FixedWidthTextTableSchema.load(string));
    }

    public FixedWidthTextTableSchema getFixedWidthSchema() {
        return this.m_schema;
    }

    public void setFixedWidthSchema(FixedWidthTextTableSchema fixedWidthTextTableSchema) {
        this.m_schema = fixedWidthTextTableSchema;
    }

    protected void read(InputStream inputStream, TableReadListener tableReadListener) throws IOException, DataParseException {
        String string;
        int n = 0;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            ++n;
            for (int i = 0; i < this.m_schema.getColumnCount(); ++i) {
                int n2 = this.m_schema.getColumnStart(i);
                int n3 = this.m_schema.getColumnEnd(i);
                tableReadListener.readValue(n, i + 1, string.substring(n2, n3));
            }
        }
    }

    protected ArrayList getColumnNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.m_schema.getColumnCount(); ++i) {
            arrayList.add(this.m_schema.getColumnName(i));
        }
        return arrayList;
    }
}

