/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.query;

import javax.swing.DefaultBoundedRangeModel;
import prefuse.util.TypeLib;
import prefuse.util.ui.ValuedRangeModel;

public class NumberRangeModel
extends DefaultBoundedRangeModel
implements ValuedRangeModel {
    protected Class m_type;
    protected Number m_min;
    protected Number m_max;
    protected Number m_lo;
    protected Number m_hi;

    public NumberRangeModel(int n, int n2, int n3, int n4) {
        this(new Integer(n), new Integer(n2), new Integer(n3), new Integer(n2));
    }

    public NumberRangeModel(long l, long l2, long l3, long l4) {
        this(new Long(l), new Long(l2), new Long(l3), new Long(l4));
    }

    public NumberRangeModel(float f, float f2, float f3, float f4) {
        this(new Float(f), new Float(f2), new Float(f3), new Float(f4));
    }

    public NumberRangeModel(double d, double d2, double d3, double d4) {
        this(new Double(d), new Double(d2), new Double(d3), new Double(d4));
    }

    public NumberRangeModel(Number number, Number number2, Number number3, Number number4) {
        this.m_type = TypeLib.getPrimitiveType(number3.getClass());
        this.setValueRange(number, number2, number3, number4);
    }

    protected void updateRange() {
        if (this.m_type == Integer.TYPE) {
            this.setRange(this.m_lo.intValue(), this.m_hi.intValue() - this.m_lo.intValue(), this.m_min.intValue(), this.m_max.intValue());
        } else if (this.m_type == Long.TYPE) {
            long l = this.m_max.longValue() - this.m_min.longValue();
            if (l == 0L) {
                this.setRange(0, 0, 0, 0);
            } else {
                long l2 = this.m_lo.longValue() - this.m_min.longValue();
                long l3 = this.m_hi.longValue() - this.m_min.longValue();
                int n = 10000 * (int)(l2 / l);
                int n2 = 10000 * (int)(l3 / l) - n;
                this.setRange(n, n2, 0, 10000);
            }
        } else {
            double d = this.m_max.doubleValue() - this.m_min.doubleValue();
            if (d == 0.0) {
                this.setRange(0, 0, 0, 0);
            } else {
                double d2 = this.m_lo.doubleValue() - this.m_min.doubleValue();
                double d3 = this.m_hi.doubleValue() - this.m_min.doubleValue();
                int n = 10000 * (int)(d2 / d);
                int n3 = 10000 * (int)(d3 / d) - n;
                this.setRange(n, n3, 0, 10000);
            }
        }
    }

    protected void setRange(int n, int n2, int n3, int n4) {
        super.setRangeProperties(n, n2, n3, n4, false);
    }

    public void setRangeProperties(int n, int n2, int n3, int n4, boolean bl) {
        if (n3 != this.getMinimum() || n4 != this.getMaximum()) {
            throw new IllegalArgumentException("Can not change min or max.");
        }
        this.m_lo = null;
        this.m_hi = null;
        super.setRangeProperties(n, n2, n3, n4, bl);
    }

    public void setValueRange(Number number, Number number2, Number number3, Number number4) {
        this.m_lo = number;
        this.m_hi = number2;
        this.m_min = number3;
        this.m_max = number4;
        this.updateRange();
    }

    public void setValueRange(double d, double d2, double d3, double d4) {
        this.m_lo = new Double(d);
        this.m_hi = new Double(d2);
        this.m_min = new Double(d3);
        this.m_max = new Double(d4);
        this.updateRange();
    }

    public void setValueRange(int n, int n2, int n3, int n4) {
        this.m_lo = new Integer(n);
        this.m_hi = new Integer(n2);
        this.m_min = new Integer(n3);
        this.m_max = new Integer(n4);
        this.updateRange();
    }

    public void setValueRange(long l, long l2, long l3, long l4) {
        this.m_lo = new Long(l);
        this.m_hi = new Long(l2);
        this.m_min = new Long(l3);
        this.m_max = new Long(l4);
        this.updateRange();
    }

    public Object getMinValue() {
        return this.m_min;
    }

    public void setMinValue(Number number) {
        this.setValueRange((Number)this.getLowValue(), (Number)this.getHighValue(), number, this.m_max);
    }

    public Object getMaxValue() {
        return this.m_max;
    }

    public void setMaxValue(Number number) {
        this.setValueRange((Number)this.getLowValue(), (Number)this.getHighValue(), this.m_min, number);
    }

    public Object getLowValue() {
        if (this.m_lo == null) {
            this.m_lo = (Number)this.value(this.getValue());
        }
        return this.m_lo;
    }

    public void setLowValue(Number number) {
        this.setValueRange(number, (Number)this.getHighValue(), this.m_min, this.m_max);
    }

    public Object getHighValue() {
        if (this.m_hi == null) {
            this.m_hi = (Number)this.value(this.getValue() + this.getExtent());
        }
        return this.m_hi;
    }

    public void setHighValue(Number number) {
        this.setValueRange((Number)this.getLowValue(), number, this.m_min, this.m_max);
    }

    protected Object value(int n) {
        int n2 = this.getMinimum();
        int n3 = this.getMaximum();
        if (this.m_type == Double.TYPE || this.m_type == Float.TYPE) {
            double d = (double)(n - n2) / (double)(n3 - n2);
            double d2 = this.m_min.doubleValue();
            double d3 = d2 + d * (this.m_max.doubleValue() - d2);
            return this.m_type == Float.TYPE ? (Number)new Float((float)d3) : (Number)new Double(d3);
        }
        if (this.m_type == Long.TYPE) {
            long l = this.m_min.longValue();
            long l2 = l + (long)(n - n2) * (this.m_max.longValue() - l) / (long)(n3 - n2);
            return new Long(l2);
        }
        return new Integer(n);
    }

    public void setMinimum(int n) {
        throw new UnsupportedOperationException();
    }

    public void setMaximum(int n) {
        throw new UnsupportedOperationException();
    }

    public void setValue(int n) {
        this.m_lo = null;
        super.setValue(n);
    }

    public void setExtent(int n) {
        this.m_hi = null;
        super.setExtent(n);
    }
}

