/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import prefuse.data.Table;
import prefuse.data.event.TableListener;
import prefuse.util.StringLib;
import prefuse.util.collections.CopyOnWriteArrayList;
import prefuse.util.collections.IntIterator;

public class PrefuseTableModel
implements TableModel,
TableListener {
    private CopyOnWriteArrayList m_listeners = new CopyOnWriteArrayList();
    private int[] m_rowmap;
    private Table m_table;

    public PrefuseTableModel(Table table) {
        this.m_table = table;
    }

    private void initRowMap() {
        this.m_rowmap = new int[this.m_table.getRowCount()];
        IntIterator intIterator = this.m_table.rows();
        int n = 0;
        while (intIterator.hasNext()) {
            this.m_rowmap[n] = intIterator.nextInt();
            ++n;
        }
    }

    private int getRow(int n) {
        if (this.m_rowmap == null) {
            this.initRowMap();
        }
        return this.m_rowmap[n];
    }

    public int getColumnCount() {
        return this.m_table.getColumnCount();
    }

    public int getRowCount() {
        return this.m_table.getRowCount();
    }

    public boolean isCellEditable(int n, int n2) {
        return this.m_table.isCellEditable(n, n2);
    }

    public Class getColumnClass(int n) {
        return this.m_table.getColumnType(n);
    }

    public Object getValueAt(int n, int n2) {
        Object object = this.m_table.get(this.getRow(n), n2);
        if (object != null && object.getClass().isArray()) {
            return StringLib.getArrayString(object);
        }
        return object;
    }

    public void setValueAt(Object object, int n, int n2) {
        this.m_table.set(this.getRow(n), n2, object);
    }

    public String getColumnName(int n) {
        return this.m_table.getColumnName(n);
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.m_listeners.add(tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.m_listeners.remove(tableModelListener);
    }

    public void tableChanged(Table table, int n, int n2, int n3, int n4) {
        Object[] objectArray;
        if (n4 == 1 || n4 == -1) {
            this.m_rowmap = null;
        }
        if ((objectArray = this.m_listeners.getArray()).length == 0) {
            return;
        }
        TableModelEvent tableModelEvent = new TableModelEvent(this, n, n2, n3, n4);
        for (int i = 0; i < objectArray.length; ++i) {
            ((TableModelListener)objectArray[i]).tableChanged(tableModelEvent);
        }
    }
}

