package testjdt3;

import java.util.HashMap;
import java.util.Vector;

import org.eclipse.jdt.core.dom.IMethodBinding;

/**
 * Class to store communications.
 * TODO changer en +++
 * @author jroyer
 *
 */
public class Communications {
	
	/** 
	 * Table for communications.
	 */
	private HashMap<String, InfoCom> table;
	
	/**
	 * Default constructor.
	 */
	public Communications() {
		this.table = new HashMap<String, InfoCom>();
	}
	
	/**
	 * Get the communications of an emitter.
	 * @param em
	 * @return
	 */
	public InfoCom getCom(String em) {
		return this.table.get(em);
	}

	/**
	 * Add in the communications of emitter em the receiver rec
	 * with the message mesg.
	 * @param em
	 * @param rec
	 * @param im
	 */
	public void addCom(String em, String rec, IMethodBinding im) {
		InfoCom com;
		Vector<IMethodBinding> vec; 
		if (this.table.containsKey(em)) {
			com = this.table.get(em);
			if (!com.contains(rec, im)) {
				com.addCom(rec, im);
			} 
		} else {
			// em is unknown in the table
			com = new InfoCom();
			com.addCom(rec, im);
		}
		this.table.put(em, com);
	}
	
	/**
	 * String description.
	 */
	public String toString() {
		String result = "";
		for (String em : this.table.keySet()) {
			String tmp = " Communications from " + em;
			InfoCom com = this.table.get(em);
				result += tmp +  com;
		}
		return result;
	}
}
