package testjdt3;

import testjdt3.Decision.Values;

/**
 * Class for information about the types
 * @author jroyer
 *
 */
public class Information {
	
	/**
	 * Decision indicator.
	 */
	private Decision data;
	
	/**
	 * Main point indicator.
	 */
	private boolean root;
	
	/**
	 * Add type resolved.
	 */
	private MyIType ibind;

	/**
	 * Default constructor.
	 */
	public Information() {
		this.data = new Decision();
		this.ibind = null;
		this.root = false;
	}
	
	/**
	 * Constructor for root type.
	 * @param r
	 */
	public Information(boolean r) {
		this(); 
		this.root = true;
	}

	/**
	 * String description.
	 */
	public String toString() {
		String result = "";
		if (this.data.isDataType()) {
			result = " Data type ";
		} else if (this.data.isComponentType()) {
			result = " Component type ";
		} else {
			result = " undefined ";
		}
		if (this.root) {
			result += " ROOT ";
		}
		if (this.ibind != null) {
			result += " binding " + this.ibind;
		}
		return result;
	}
	
	/**
	 * Set data type indicator.
	 * @param data
	 */
	public void setDataType(boolean data) {
		if (data) {
			this.data = new Decision(Values.DATA);
		}
	}

	/**
	 * Set component type indicator.
	 * @param data
	 */
	public void setComponentType(boolean data) {
		if (data) {
			this.data = new Decision(Values.COMP);
		} 
	}
	
	/**
	 * Set the resolved type.
	 * @param it
	 */
	public void setType(MyIType it) {
		this.ibind = it;
	}
	
	/**
	 * Set root indicator.
	 */
	public void setRoot() {
		this.root = true;
	}

	/**
	 * Check if type information is resolved.
	 * @return
	 */
	public boolean isResolved() {
		// TODO
		//return (this.ibind != null);
		return (this.ibind.isResolved());
	}
	
	/**
	 * test if has fields.
	 * @return
	 */
	public boolean hasFields() {
		return this.ibind.hasFields();
	}
	
	/**
	 * Check if type information is resolved.
	 * @return
	 */
	public boolean isDataType() {
		return this.data.isDataType();
	}

	/**
	 * Get ITypeBinding.
	 * @return
	 */
	public MyIType getIbind() {
		return ibind;
	}
}
