package emn.fr.ascola.view;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

/**
 * Parameters board for prefuse views.
 * @author jroyer
 * 31/5/2009
  * TODO revoir
 */
public class ParametersDialog extends Dialog {
	private Shell shell;
	private Display display;
	
	// set indicators
	private boolean linkNumbering = false;
	private boolean artefactNumbering = false;
    // store the strength choice
    private String strength = PrefuseViewer.STRING_BASIC;
    //
    private int width = 500;
    private int heigth = 60;

	public ParametersDialog(Shell parent) {
		super(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		this.setText("Choose parameters for prefuse views");
	}
	
	/**
	 * Create the content.
	 */
	public void createContent() {
		//this.linkAndArtefact();
		this.chooseForce();
		this.finish();
	}
	
	/**
	 * open the dialog.
	 * @return
	 */
	public void open () {
		Shell parent = this.getParent();
		this.shell = new Shell(parent, SWT.DIALOG_TRIM | SWT.RESIZE);
		this.display = this.shell.getDisplay();
		this.shell.setLayout(new GridLayout());
		this.createContent();
		this.shell.open();
		//Display display = parent.getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
	}
	
	/**
	 * Link and artefact numbering.
	 */
	public void linkAndArtefact () {
		// ---------------------------------------------------
		// label and  composite for Link
		Label label = new Label(this.shell, SWT.CENTER | SWT.BORDER);
		label.setText("Node Link: ");
		label.setBackground(this.display.getSystemColor(SWT.COLOR_MAGENTA));
		label.setAlignment(SWT.CENTER);

		Composite lcomposite = new Composite(this.shell, SWT.CENTER);
		RowLayout rl0 = new RowLayout();
		rl0.justify = true;
		rl0.pack = false;
		lcomposite.setLayout(rl0);
		
		// link numbering
		Button lnumbering = new Button(lcomposite, SWT.CHECK);
		lnumbering.setText("Numbering");
		lnumbering.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				linkNumbering = !linkNumbering;
			}
		});
		
		// ---------------------------------------------------
		// label and composite for artefact
		label = new Label(this.shell, SWT.CENTER);
		label.setText("Node Artefact: ");
		label.setBackground(this.display.getSystemColor(SWT.COLOR_CYAN));

		Composite acomposite = new Composite(this.shell, SWT.CENTER);
		RowLayout rl = new RowLayout();
		rl.justify = true;
		rl.pack = false;
		acomposite.setLayout(rl);

		// numbering
		Button anumbering = new Button(acomposite, SWT.CHECK);
		anumbering.setText("Numbering");
		anumbering.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				artefactNumbering = !artefactNumbering;
			}
		});
		// ---------------------------------------------------
		this.heigth += 120;
	}
	
	/** 
	 * Black and white or colored.
	 */
	public void colorOrNot () {
		
	}

	/**
	 * Choose edge strength.
	 */
	public void chooseForce () {
		Label alabel = new Label(this.shell, SWT.CENTER | SWT.BORDER);
		alabel.setText("Edge strength: ");
		alabel.setBackground(this.display.getSystemColor(SWT.COLOR_DARK_YELLOW));
		// composite radio button
	    Composite thecomposite = new Composite(shell, SWT.NULL);
	    thecomposite.setLayout(new RowLayout());
	    // define the common listener
	    Listener radioGroup = new Listener () {
			public void handleEvent(Event event) {
				strength = ((Button) event.widget).getText();
				//System.out.println(" button " + strength);
			}
	    };
	    Button dButton = new Button(thecomposite, SWT.RADIO);
	    dButton.setText(PrefuseViewer.STRING_BASIC);
	    dButton.addListener (SWT.Selection, radioGroup);
	    Button fButton = new Button(thecomposite, SWT.RADIO);
	    fButton.setText(PrefuseViewer.STRING_SMALL);
	    fButton.addListener (SWT.Selection, radioGroup);
	    Button lButton = new Button(thecomposite, SWT.RADIO);
	    lButton.setText(PrefuseViewer.STRING_MIDDLE);
	    lButton.addListener (SWT.Selection, radioGroup);
	    Button cButton = new Button(thecomposite, SWT.RADIO);
	    cButton.setText(PrefuseViewer.STRING_CIRCLE);  
	    cButton.addListener (SWT.Selection, radioGroup);
	    Button rButton = new Button(thecomposite, SWT.RADIO);
	    rButton.setText(PrefuseViewer.STRING_RADIAL);  
	    rButton.addListener (SWT.Selection, radioGroup);
	    Button bButton = new Button(thecomposite, SWT.RADIO);
	    bButton.setText(PrefuseViewer.STRING_BALLOON);  
	    bButton.addListener (SWT.Selection, radioGroup);
	    this.heigth += 60;
	}
	
	/**
	 * Finish button.
	 */
	public void finish () {
		// ---------------------------------------------------
		// bouton finish/close
		Button rateButton = new Button(this.shell, SWT.PUSH);
		rateButton.setText("Finish!");
		rateButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				shell.close();
			}
			public void widgetDefaultSelected(SelectionEvent e) {
			}
		});
		
		// Move the this.shell to the center of the top level shell.
        Rectangle shellBounds = this.shell.getBounds();
        Point dialogSize = this.shell.getSize();

        this.shell.setLocation(
        		shellBounds.x + (shellBounds.width - dialogSize.x) / 2,
        		shellBounds.y + (shellBounds.height - dialogSize.y) / 2);

		// local dialog
		this.shell.pack();
		this.shell.setSize(this.width, 60 + this.heigth);
		this.shell.setLocation(200, 200);
	}

	public boolean isLinkNumbering() {
		return linkNumbering;
	}

	public boolean isArtefactNumbering() {
		return artefactNumbering;
	}

	/**
	 * @param strength the strength to set
	 */
	public void setStrength(String str) {
		this.strength = str;
	}

	/**
	 * @return the strength
	 */
	public String getStrength() {
		return this.strength;
	}

}
