package emn.fr.ascola.extractor;

import java.util.HashMap;
import java.util.Vector;

import org.eclipse.jdt.core.dom.IMethodBinding;

/**
 * Class to store communications from an emitter type.
 * InfoCom is organized by receiver types.
 * @author jroyer
 *
 */
public class Communications extends HashMap<String, InfoCom> {
	private static final long serialVersionUID = 1L;

	/**
	 * Default constructor.
	 */
	public Communications() {
		super();
		// TODO not right with addCom behaviour
		// force init of all component types
		//for (String tname : cmptypes) {
		//	this.put(tname, new InfoCom());
		//}
	}
	
	/**
	 * Get the communications of an emitter.
	 * @param em
	 * @return
	 */
	public InfoCom getCom(String em) {
		return this.get(em);
	}

	/**
	 * Add in the communications of emitter em the receiver rec
	 * with the message mesg.
	 * @param em
	 * @param rec
	 * @param im
	 */
	public void addCom(String em, String rec, IMethodBinding im) {
		InfoCom com;
		Vector<IMethodBinding> vec; 
		if (this.containsKey(em)) {
			com = this.get(em);
			if (!com.contains(rec, im)) {
				com.addCom(rec, im);
			} 
		} else {
			// em is unknown in the table
			com = new InfoCom();
			com.addCom(rec, im);
		}
		this.put(em, com);
	}
	
	/**
	 * String description.
	 */
	public String toString() {
		String result = "";
		for (String em : this.keySet()) {
			String tmp = " Communications from " + em;
			InfoCom com = this.get(em);
				result += tmp +  com;
		}
		return result;
	}
	
	/**
	 * Check that each required of each type is also provided.
	 * TODO ameliore le retour
	 */
	public void checkRequiredProvided() {
		//System.out.println(" checkRequiredProvided ");
		for (String tn : this.keySet()) {
			//System.out.println(" checkRequiredProvided for " + tn);
			InfoCom info = this.get(tn);
			//System.out.println(" InfoCom " + info);
			// look at the receiver type
			for (String trec : info.keySet()) {
				// look at each required method
				for (IMethodBinding im : info.get(trec)) {
					//System.out.println(" Required " + im);
					// trouver la correspondante ?
					ASTActionDelegate.provided.exists(trec, im);
				}
			}
		}
	}
}
