package emn.fr.ascola.extractor;

/**
 * Class for decision
 * @author jroyer
 *
 */
public class Decision {

	/**
	 * Three logical values.
	 * @author jroyer
	 *
	 */
	public enum Values {COMP, DATA, UNDEF};
	
	/**
	 * Local value.
	 */
	private Values value;
	
	/**
	 * Constructor.
	 */
	public Decision() {
		this.value = Values.UNDEF;
	}
	
	/**
	 * Constructor with values.
	 */
	public Decision(Values v) {
		this.value = v;
	}
	
	/**
	 * Indicates that a method use the type as formal parameter
	 * @return
	 */
	public boolean isDataType() {
		return this.value == Values.DATA;
	}
	
	/**
	 * Test for component type.
	 * @return
	 */
	public boolean isComponentType() {
		return this.value == Values.COMP;
	}
	
	public boolean isUndefined() {
		return this.value == Values.UNDEF;
	}
}
