package emn.fr.ascola.extractor;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * General class to simply display some texts.
 * @author jroyer
 *
 */
public class DisplayText {

	private Display display;
	private Shell shell;
	private Text area;

	/**
	 *  Constructor.
	 */
	public DisplayText(Display dp, String title) {
		this.display = dp;
		this.shell = new Shell(dp);
		this.shell.setText(title);
		GridLayout gridLayout = new GridLayout(2, false);
		this.shell.setLayout(gridLayout);

		// the text area
		this.area = new Text(shell, SWT.MULTI | SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);
		this.area.setEditable(false);
		this.area.setTextLimit(10000000);
		this.area.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		// TODO one button 
		
		// packing the display
		this.shell.pack();
		this.shell.setBounds(50,50,500,500);
		this.shell.setSize(400, 400);
	}
	
	/**
	 * To change title.
	 * @param t
	 */
	public void setTitle(String t) {
		this.shell.setText(t);
	}
	
	/**
	 * Clear and set text.
	 * @param t
	 */
	public void setText(String t) {
		this.clean();
		this.area.setText(t);
	}
	
	/**
	 * Concatenate a string.
	 * @param t
	 */
	public void append(String t) {
		this.area.append(t);
	}
	
	/**
	 * Clear selection.
	 */
	public void clean() {
		this.area.clearSelection();
	}
	
	/**
	 * open and wait.
	 */
	public void open() {
		this.shell.open();
	}
	
	/**
	 * loop to wait.
	 */
	public void loop() {
		// Set up the event loop.
		while (!this.shell.isDisposed()) {
			if (!this.display.readAndDispatch()) {
			// If no more entries in event queue
				this.display.sleep();
			}
		}
	}
	
	/**
	 * Dispose.
	 */
	public void dispose() {
		this.display.dispose();
	}

	/**
	 * Set location x y.
	 * @param x
	 * @param y
	 */
	public void setLocation(int x, int y) {
		this.shell.setLocation(x, y);
	}
}
