
package emn.fr.ascola.extractor;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;

/**
 * Dedicated visitor to extract the structure of a type of interest.
 */
class ExtractStructure extends SimpleVisitor {

	/**
	 *  Maintype binding.
	 */
	private ITypeBinding maintype = null;
	
	/**
	 * Visit ASTNode.
	 * to collect a possible structure.
	 */
	public void preVisit(ASTNode node) {
		// assume it is the main type but ensured by the caller
		if (node.getNodeType() == ASTNode.TYPE_DECLARATION) {
			TypeDeclaration main = (TypeDeclaration) node;
			this.maintype = main.resolveBinding();
			//String fullname = this.maintype.getQualifiedName();
			String fullname = this.maintype.getBinaryName();
			//System.out.println(" names " + this.maintype.getBinaryName());
			//System.out.println(" ASTNodeExtracting structure for " + fullname);
			//System.out.println(" isof" + ASTActionDelegate.table.isOfInterest(fullname));
			//System.out.println(" resolved " + !ASTActionDelegate.table.isResolved(fullname));
			if (ASTActionDelegate.table.isOfInterest(fullname) 
					&& !ASTActionDelegate.table.isResolved(fullname)
					&& this.maintype.isClass()) {
				//System.out.println(" passed ! ");
				// set component type indicator
				ASTActionDelegate.table.setComponentType(fullname);
				// add the resolved type in the table
				MyIType mit = ASTActionDelegate.table.get(fullname).getIbind();
				mit.setIbind(this.maintype);
				// compute the structure, see MyIType
				mit.storeStructure();
				ASTActionDelegate.table.setType(fullname, mit);
				}
		}
	}

}