package emn.fr.ascola.extractor;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;

/**
 * A generic ASTParser which could be configure with
 * the visitor type.
 *
 */
public class GenericASTParser {
	
	/**
	 * The associated visitor.
	 */
	private SimpleVisitor visitor;
	
	public GenericASTParser(SimpleVisitor vis) {
		this.visitor = vis;
	}
	
	/**
	 * Launch the visitor.
	 * @param unit
	 */
	public void run(CompilationUnit unit) {
		this.visitor.process(unit);
	}

	/**
	 * Parses source code.
	 * @param lwUnit
	 *            the Java Model handle for the compilation unit
	 * @return the root AST node of the parsed source
	 */
	protected CompilationUnit parse(ICompilationUnit lwUnit) {
		ASTParser parser = ASTParser.newParser(AST.JLS3);
		parser.setKind(ASTParser.K_COMPILATION_UNIT);
		parser.setSource(lwUnit); // set source
		parser.setResolveBindings(true); // we need bindings later on
		return (CompilationUnit) parser.createAST(null /* IProgressMonitor */); // parse
	}
	


}