package emn.fr.ascola.extractor;
import java.util.HashMap;
import java.util.Vector;

import org.eclipse.jdt.core.dom.IMethodBinding;

/**
 * Class to store method reference from calls in the code.
 * The first argument is the receiver type (or class of the methods)
 * @author jroyer
 *
 */
public class InfoCom extends HashMap<String, Vector<IMethodBinding>> {

	
	/**
	 * String representation.
	 */
	public String toString() {
		String result = "";
		for (String rec : this.keySet()) {
			result += " to " + rec + ": " + this.get(rec) + " ; ";
		}
		return result + "\n";
	}
	
	/**
	 * Add  for entry rec the new method.
	 * @param rec
	 * @param im
	 */
	public void addCom(String rec, IMethodBinding im) {
		Vector<IMethodBinding>  vec;
		if (this.containsKey(rec)) {
			vec = this.get(rec);
		} else {
			vec = new Vector<IMethodBinding>();
		}
		vec.add(im);
		this.put(rec, vec);
	}
	
	/**
	 * Check if the method is already in the hashmap.
	 * @return
	 */
	public boolean contains(String rec, IMethodBinding im) {
		boolean result = false;
		if (this.containsKey(rec)) {
			for (IMethodBinding jm : this.get(rec)) {
				if (im.isEqualTo(jm)) {
					return true;
				}
			}
		}
		return false;
	}

}
