package emn.fr.ascola.extractor;

import java.util.HashMap;
import java.util.Vector;

import org.eclipse.jdt.core.IField;

/**
 * Class to store per type name the set of final static services
 * public or default package fields
 * @author jroyer
 * 3/6/2009
 */
public class ProvidedConstant extends HashMap<String, Vector<IField>>{
	private static final long serialVersionUID = 1L;

	/**
	 * String representation.
	 */
	public String toString() {
		String result = "";
		for (String typ : this.keySet()) {
			result += typ + " :::";
			for(IField f : this.get(typ)) {
					result += " " + f.getElementName();
			}
			result += "\n";
		}
		return result;
	}
	
	/**
	 * Compute the provided interface of a type.
	 * @param key
	 * @return an array of String signatures.
	 */
	public Vector<String> getProvided(String key) {
		Vector<IField> fields = this.get(key);
		Vector<String> result = new Vector<String>();
		for(IField f : fields) {
			result.add(f.getElementName());
		}
		return result;
	}	

}
