package emn.fr.ascola.view;

/**
 * A panel view for informations associated to node.
 * @author jroyer
 * 20/04/2008
 * Converted to ATF-frontend (0.1.2) viewer plugins
 * @author nicolas anquetil (NA)
 * 19/06/2008
 * Updated to ATF-frontend (0.1.5)
 * @author nicolas anquetil (NA)
 * 05/12/2008
 * 3/5/2009 add for direct link
 * 19/05/2009 size of the name JPanel
 * 20/5/2009
 * add link type for multi-edge (pb for radial and other ?)
 * 25/5/2009 add in/out degrees
 * 1/6/2009
 * 6/6/2009 
 * 
 */
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import prefuse.visual.VisualItem;

public class ATFItemView extends JPanel {
	protected static final long serialVersionUID = 1L;
	// label for information
	protected JLabel tinfo, info, info11, info12, info21, info22;
	protected JScrollPane spane;
	protected JPanel keys, values;

	// Initialization constants for graphical parameters
	final protected int KEYSGRIDROWS = 3;
	final protected int KEYSGRIDCOLS = 1;
	final protected int KEYSPREFWIDTH  = 100+50;
	final protected int KEYSPREFHEIGHT = 50;
	final protected int VALSGRIDROWS = 3;
	final protected int VALSGRIDCOLS = 1;
	final protected int VALSPREFWIDTH  = 400+150;
	final protected int VALSPREFHEIGHT = 50;

	final protected String TINFOLABEL = "";
	final protected String INFOLABEL = "";
	final protected String INFO11LABEL = "";
	final protected String INFO12LABEL = "";
	final protected String INFO21LABEL = "";
	final protected String INFO22LABEL = "";

	final protected boolean SETSIZE = true;
	final protected int SIZEWIDTH  = 800;
	final protected int SIZEHEIGHT = 50;
	final protected int MAXSIZEWIDTH  = 700;
	final protected int MAXSIZEHEIGHT = 50;
	final protected int LOCX = 400;
	final protected int LOCY = 300;

	/**
	 * Default constructor of a panel at the top.
	 */
	public ATFItemView() {
		super();
		
		this.keys = new JPanel(new GridLayout(KEYSGRIDROWS, KEYSGRIDCOLS));
		this.keys.setPreferredSize(new Dimension(KEYSPREFWIDTH, KEYSPREFHEIGHT+50));   
		this.values = new JPanel(new GridLayout(VALSGRIDROWS, VALSGRIDCOLS));
		this.values.setPreferredSize(new Dimension(VALSPREFWIDTH, VALSPREFHEIGHT+50));   
		this.setLayout(new FlowLayout(FlowLayout.LEADING,0,0)); 

		this.tinfo = new JLabel(TINFOLABEL);
		this.info = new JLabel(INFOLABEL);
		this.info11 = new JLabel(INFO11LABEL);
		this.info12 = new JLabel(INFO12LABEL);
		this.info21 = new JLabel(INFO21LABEL);
		this.info22 = new JLabel(INFO22LABEL);
		this.info22.setPreferredSize(new Dimension(1500, 10));
		this.spane = new JScrollPane(this.info22);
		this.spane.setSize(VALSPREFWIDTH, 60);

		this.keys.add(tinfo);
		this.values.add(info);
		this.keys.add(info11);
		this.values.add(info12);
		this.keys.add(info21);
		this.values.add(this.spane, BorderLayout.WEST);

		this.add(keys);
		this.add(values);

		if (SETSIZE) {
			this.setSize(SIZEWIDTH, SIZEHEIGHT+50);
		}
		// size don't grow with zoom and enlargement
		this.setMaximumSize(new Dimension(MAXSIZEWIDTH, MAXSIZEHEIGHT));
		this.setAlignmentX(FlowLayout.LEFT);
		this.setLocation(LOCX, LOCY);
	}
	
	/**
	 * To visualize an item in the panel.
	 * @param vi visual item
	 */
	public void setInfo(VisualItem vi) {
		//System.out.println(" group " + vi.getGroup());
		// test edge or node group
		if (vi.getGroup().equals(PrefuseViewer.STRING_NODES)) {
			if (vi.getBoolean(PrefuseViewer.STRING_KIND)) {
				this.tinfo.setText(" Component type: ");
				//this.info11.setText("Type: ");
				//this.info12.setText(vi.getString(PrefuseViewer.STRING_TYPE));
				//this.info21.setText("Name:");
				this.info22.setText(vi.getString(PrefuseViewer.STRING_TYPE));
			} else {
				this.tinfo.setText(" Data type: ");
				//this.info.setText(vi.getString(PrefuseViewer.STRING_TYPE));
				this.info22.setText(vi.getString(PrefuseViewer.STRING_TYPE));
			}
		} else {
			// else edge
			if (vi.getInt(PrefuseViewer.STRING_KIND) == PrefuseViewer.COMPOSITE) {
				// composite
				this.tinfo.setText(" Composite: ");
				//this.info.setText("+++");
				this.info11.setText(" Attribute: ");
				this.info12.setText(vi.getString(PrefuseViewer.STRING_NAME));
			} else if (vi.getInt(PrefuseViewer.STRING_KIND) == PrefuseViewer.SUBTYPING) {
				// subtyping
				this.tinfo.setText(" Subtyping: ");
			} else {
				// communication
				//String met = vi.getString(PrefuseViewer.STRING_NAME);
				this.tinfo.setText(" Communication from ");
				//this.info.setText(vi.getString(PrefuseViewer.STRING_EMITTER) + 
				//		" to " + vi.getString(PrefuseViewer.STRING_RECEIVER));
				//this.info11.setText(" Return type:");
				//this.info12.setText(vi.getString(PrefuseViewer.STRING_RTYPE));
				//this.info21.setText(" Parameter types:");
				this.info22.setText(vi.getString(PrefuseViewer.STRING_EMITTER) + 
							" to " + vi.getString(PrefuseViewer.STRING_RECEIVER));
			}
		}
	}
	
	/**
	 * To clean up the view.
	 */
	public void clean() {
		this.tinfo.setText(PrefuseViewer.NULL_STRING);
		this.info.setText(PrefuseViewer.NULL_STRING);
		this.info11.setText(PrefuseViewer.NULL_STRING);
		this.info12.setText(PrefuseViewer.NULL_STRING);
		this.info21.setText(PrefuseViewer.NULL_STRING);
		this.info22.setText(PrefuseViewer.NULL_STRING);
	}
}
