package emn.fr.ascola.view;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import emn.fr.ascola.extractor.ASTActionDelegate;

/**
 * Parameters board for prefuse views.
 * @author jroyer
 * 5/6/2009
 * To choose edges.
 */
public class CheckedDialog extends Dialog {
	private Shell shell;
	private Display display;
	
	// set indicators
	private boolean subtyping = false;
	private boolean composition = false;
	private boolean communication = false;
    //
    private int width = 500;
    private int heigth = 60;

	public CheckedDialog(Shell parent) {
		super(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		this.setText("Choose edges to view");
		this.communication = false;
		this.subtyping = false;
		this.composition = false;
	}
	
	/**
	 * Create the content.
	 */
	public void createContent() {
		this.chooseEdges();
		this.finish();
	}
	
	/**
	 * open the dialog.
	 * @return
	 */
	public void open () {
		Shell parent = this.getParent();
		this.shell = new Shell(parent, SWT.DIALOG_TRIM | SWT.RESIZE);
		this.display = this.shell.getDisplay();
		this.shell.setLayout(new GridLayout());
		this.createContent();
		this.shell.open();
		//Display display = parent.getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
	}
	

	/**
	 * Choose edge strength.
	 */
	public void chooseEdges () {
		Label alabel = new Label(this.shell, SWT.CENTER | SWT.BORDER);
		alabel.setText("Edge kinds: ");
		alabel.setBackground(this.display.getSystemColor(SWT.COLOR_CYAN));
		
	    // Create three push buttons
	    Button com = new Button(shell, SWT.CHECK);
	    com.setText(ASTActionDelegate.communication);
		com.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				communication = !communication;
			}
		});
	    Button comp = new Button(shell, SWT.CHECK);
	    comp.setText(ASTActionDelegate.composition);
	    comp.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				composition= !composition;
			}
		});
	    Button sub = new Button(shell, SWT.CHECK);
	    sub.setText(ASTActionDelegate.subtyping);
	    sub.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				 subtyping = !subtyping;
			}
		});

	    this.heigth += 60;
	}
	
	/**
	 * Finish button.
	 */
	public void finish () {
		// ---------------------------------------------------
		// bouton finish/close
		Button rateButton = new Button(this.shell, SWT.PUSH);
		rateButton.setText("Finish!");
		rateButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				shell.close();
			}
			public void widgetDefaultSelected(SelectionEvent e) {
			}
		});
		
		// Move the this.shell to the center of the top level shell.
        Rectangle shellBounds = this.shell.getBounds();
        Point dialogSize = this.shell.getSize();

        this.shell.setLocation(
        		shellBounds.x + (shellBounds.width - dialogSize.x) / 2,
        		shellBounds.y + (shellBounds.height - dialogSize.y) / 2);

		// local dialog
		this.shell.pack();
		this.shell.setSize(this.width, 60 + this.heigth);
		this.shell.setLocation(200, 200);
	}

	public boolean isSubtyping() {
		return subtyping;
	}

	public boolean isComposition() {
		return composition;
	}

	public boolean isCommunication() {
		return communication;
	}

}
