package emn.fr.ascola.view;

import java.awt.BasicStroke;

import prefuse.visual.VisualItem;

/**
 * Multiple and loop edge renderer.
 * This solution assumes that we have a fields "count" int.class
 *  in the edge which gives the edge numbering between same pair of nodes
 * @author jroyer
 *  20/4/2008
 *  1/6/2009
 *  TODO problem with the interactive selection
 */
public class MultiDashedEdgeRenderer extends MultiEdgeRenderer {

	/**
	 * Constructor.
	 * @param edgeTypeCurve type curve
	 * @param edgeArrowForward arrow head
	 */
	public MultiDashedEdgeRenderer(int edgeTypeCurve, int edgeArrowForward) {
		super(edgeTypeCurve, edgeArrowForward);
	}

	// redefine stroke
	public BasicStroke getStroke(VisualItem vi) {
		// only for communication
		return new BasicStroke(2, BasicStroke.CAP_ROUND, 
				BasicStroke.JOIN_ROUND, 10.0f, new float[]{10.0f, 10.0f}, 0.0f);
	}
}
