/*
 * Decompiled with CFR 0.152.
 */
package emn.fr.ascola.extractor;

import emn.fr.ascola.extractor.Communications;
import emn.fr.ascola.extractor.DisplayText;
import emn.fr.ascola.extractor.ExtractCommunications;
import emn.fr.ascola.extractor.ExtractStructure;
import emn.fr.ascola.extractor.Fields;
import emn.fr.ascola.extractor.GenericASTParser;
import emn.fr.ascola.extractor.InfoCom;
import emn.fr.ascola.extractor.Information;
import emn.fr.ascola.extractor.MyIType;
import emn.fr.ascola.extractor.Provided;
import emn.fr.ascola.extractor.ProvidedConstant;
import emn.fr.ascola.extractor.TypesTable;
import emn.fr.ascola.extractor.Utility;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTActionDelegate
implements IWorkbenchWindowActionDelegate {
    protected IWorkbenchWindow window;
    public static final String subtyping = "Subtyping";
    public static final String composition = "Composition";
    public static final String communication = "Communication";
    public static final String separation = "======== Copyright jroyer@emn.fr ======================================\n\n";
    public static Shell shell;
    protected IJavaProject javaProject = null;
    protected IProject project = null;
    protected String repo_name = "";
    protected Vector<ICompilationUnit> units = new Vector();
    protected Vector<IType> typesOfInterest = new Vector();
    public static TypesTable table;
    public static Communications communications;
    public static HashMap<String, String> structure;
    public static Provided provided;
    public static ProvidedConstant providedconstant;
    private DisplayText view;

    static {
        structure = new HashMap();
    }

    public void run(IAction action) {
        this.view = new DisplayText(shell.getDisplay(), "Running Analysis ... ");
        this.view.open();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        DirectoryDialog dialog = new DirectoryDialog(shell);
        dialog.setMessage("Choose a project name in the current workspace!");
        dialog.setFilterPath("");
        this.repo_name = dialog.open();
        int ind = this.repo_name.lastIndexOf(File.separator);
        if (ind != -1) {
            this.repo_name = this.repo_name.substring(ind + 1);
        }
        this.project = root.getProject(this.repo_name);
        if (this.project != null) {
            try {
                this.project.open(null);
            }
            catch (CoreException coreException) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Problem to open it", (String)("non existing project? " + this.repo_name));
                return;
            }
            this.javaProject = JavaCore.create((IProject)this.project);
            if (this.javaProject != null) {
                this.units = this.getUnitsOfInterest();
                if (this.units.size() == 0) {
                    MessageDialog.openError((Shell)this.window.getShell(), (String)"Empty project", (String)("empty project " + this.repo_name));
                } else {
                    this.typesOfInterest = this.getTypesOfInterest();
                    table = new TypesTable(this.typesOfInterest);
                    this.view.append(separation);
                    this.addSubSub();
                    for (IType it : this.typesOfInterest) {
                        this.implementR1(it);
                    }
                    table.propagateDATA();
                    this.view.append("TABLE of types of interest after propagate \n");
                    this.view.append(table.toString());
                    this.view.append(separation);
                    this.implementP3();
                    this.view.append("TABLE of types of interest after P3 \n");
                    this.view.append(table.toString());
                    this.view.append(separation);
                    this.addParentLinks();
                    this.implementP4();
                    this.view.append("COMMUNICATIONS \n");
                    this.view.append(communications.toString());
                    this.view.append(separation);
                    this.view.append("Provided interfaces and constants\n");
                    this.implementP5provided();
                    this.view.append(provided.toString());
                    this.view.append(providedconstant.toString());
                    this.view.append(separation);
                    this.view.append("Required interfaces  \n");
                    this.view.append(separation);
                    this.view.append(" have public fields  \n");
                    this.view.append(String.valueOf(table.checkPublicFields().toString()) + "\n");
                    this.view.append(separation);
                    this.view.append(" have cyclic structure  \n");
                    this.view.append(String.valueOf(table.checkCycle().toString()) + "\n");
                    this.view.append(separation);
                    this.view.append(" check that required are provided  \n");
                    communications.checkRequiredProvided();
                    this.view.append(separation);
                    this.view.append(separation);
                    table.setUndefinedInterfaces();
                    this.boundaryAnalysis();
                }
            } else {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"No Java project", (String)("No such Java project " + this.repo_name));
            }
        } else {
            MessageDialog.openError((Shell)this.window.getShell(), (String)"No project", (String)("No such project " + this.repo_name));
        }
        this.displayFinalTable();
    }

    public Vector<ICompilationUnit> getUnitsOfInterest() {
        Vector<ICompilationUnit> icu = new Vector<ICompilationUnit>();
        try {
            IPackageFragmentRoot[] ipfr = this.javaProject.getAllPackageFragmentRoots();
            int i = 0;
            while (i < ipfr.length) {
                if (!ipfr[i].isExternal()) {
                    IJavaElement[] ije = ipfr[i].getChildren();
                    int j = 0;
                    while (j < ije.length) {
                        IPackageFragment pf = (IPackageFragment)ije[j];
                        if (pf.containsJavaResources()) {
                            ICompilationUnit[] tmp = pf.getCompilationUnits();
                            int k = 0;
                            while (k < tmp.length) {
                                ICompilationUnit cu = tmp[k];
                                icu.add(cu);
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return icu;
    }

    public Vector<IType> getTypesOfInterest() {
        Vector<IType> vt = new Vector<IType>();
        int i = 0;
        while (i < this.units.size()) {
            ICompilationUnit cu = this.units.get(i);
            try {
                IType[] alls;
                IType[] iTypeArray = alls = cu.getTypes();
                int n = alls.length;
                int n2 = 0;
                while (n2 < n) {
                    IType ity = iTypeArray[n2];
                    if (ity.isClass() || ity.isInterface()) {
                        vt.add(ity);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e1) {
                e1.printStackTrace();
            }
            ++i;
        }
        this.view.append(" ASTActionDelegate found " + vt.size() + " types of interest!");
        return vt;
    }

    public void implementR1(IType it) {
        try {
            IMethod[] ims;
            IMethod[] iMethodArray = ims = it.getMethods();
            int n = ims.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod im = iMethodArray[n2];
                if (!im.isConstructor() && !im.isMainMethod()) {
                    String sig = im.getSignature();
                    String tname = Signature.toString((String)Signature.getReturnType((String)sig));
                    String fname = Utility.buildFullName(tname, it.resolveType(tname));
                    table.setDataType(fname);
                    String[] ptypes = Signature.getParameterTypes((String)sig);
                    int j = 0;
                    while (j < ptypes.length) {
                        tname = Signature.toString((String)ptypes[j]);
                        fname = Utility.buildFullName(tname, it.resolveType(tname));
                        table.setDataType(fname);
                        ++j;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public void addSubSub() {
        for (IType it : this.typesOfInterest) {
            String fname = it.getFullyQualifiedName();
            MyIType mit = ((Information)table.get(fname)).getIbind();
            try {
                String[] lsup;
                mit.setNature(it.isClass());
                String supername = it.getSuperclassName();
                if (supername == null) {
                    supername = "Object";
                }
                String sup = Utility.buildFullName(supername, it.resolveType(supername));
                mit.setSupername(sup);
                if (table.isOfInterest(sup)) {
                    MyIType mits = ((Information)table.get(sup)).getIbind();
                    mits.addSubclass(fname);
                }
                String[] stringArray = lsup = it.getSuperInterfaceNames();
                int n = lsup.length;
                int n2 = 0;
                while (n2 < n) {
                    String iname = stringArray[n2];
                    String sub = Utility.buildFullName(iname, it.resolveType(iname));
                    if (table.isOfInterest(sub)) {
                        MyIType mits = ((Information)table.get(sub)).getIbind();
                        mits.addSubinterface(fname);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    public void implementP3() {
        for (IType it : this.typesOfInterest) {
            try {
                String fn;
                if (it.isInterface() || table.isDataType(fn = it.getFullyQualifiedName())) continue;
                GenericASTParser ast = new GenericASTParser(new ExtractStructure());
                ICompilationUnit ic = it.getCompilationUnit();
                CompilationUnit cu = ast.parse(ic);
                ast.run(cu);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addParentLinks() {
        for (IType it : this.typesOfInterest) {
            String fullname = it.getFullyQualifiedName();
            Information info = (Information)table.get(fullname);
            MyIType ity = info.getIbind();
            if (!info.isComponentType()) continue;
            Fields struc = ity.getStructure();
            for (IVariableBinding iv : struc) {
                String subname = iv.getType().getBinaryName();
                ((Information)table.get(subname)).addParent(fullname);
            }
        }
    }

    public void findRoots() {
        for (IType it : this.typesOfInterest) {
            try {
                IMethod[] ims = it.getMethods();
                int i = 0;
                while (i < ims.length) {
                    IMethod im = ims[i];
                    if (im.isMainMethod()) {
                        table.setRoot(it.getFullyQualifiedName());
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    public void implementP4() {
        communications = new Communications();
        for (IType it : this.typesOfInterest) {
            GenericASTParser ast = new GenericASTParser(new ExtractCommunications());
            ICompilationUnit ic = it.getCompilationUnit();
            CompilationUnit cu = ast.parse(ic);
            ast.run(cu);
        }
    }

    public void implementP5required() {
    }

    public void implementP5provided() {
        provided = new Provided();
        providedconstant = new ProvidedConstant();
        for (IType it : this.typesOfInterest) {
            String fullname = it.getFullyQualifiedName();
            try {
                IField[] ifs;
                IMethod[] ims;
                Vector<IMethod> vec = new Vector<IMethod>();
                IMethod[] iMethodArray = ims = it.getMethods();
                int n = ims.length;
                int n2 = 0;
                while (n2 < n) {
                    int fg;
                    IMethod im = iMethodArray[n2];
                    if (!(im.isMainMethod() || Flags.isPrivate((int)(fg = im.getFlags())) && Flags.isProtected((int)fg))) {
                        vec.add(im);
                    }
                    ++n2;
                }
                provided.put(fullname, vec);
                Vector<IField> fields = new Vector<IField>();
                IField[] iFieldArray = ifs = it.getFields();
                int n3 = ifs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IField f = iFieldArray[n4];
                    int flag = f.getFlags();
                    if (Flags.isStatic((int)flag) && Flags.isFinal((int)flag) && (Flags.isPublic((int)flag) || Flags.isPackageDefault((int)flag))) {
                        fields.add(f);
                    }
                    ++n4;
                }
                providedconstant.put(fullname, fields);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void analyseMainAndConstructors() {
    }

    public void boundaryAnalysis() {
        DisplayText anotherview = new DisplayText(shell.getDisplay(), "Boundary Analysis");
        anotherview.setLocation(200, 200);
        anotherview.open();
        for (IType it : this.typesOfInterest) {
            String fullname = it.getFullyQualifiedName();
            Information info = (Information)table.get(fullname);
            MyIType ity = info.getIbind();
            if (!info.isComponentType()) continue;
            anotherview.append(separation);
            anotherview.append(" boundaryAnalysis of " + fullname + "\n\n");
            Fields struc = ity.getStructure();
            InfoCom msgs = communications.getCom(fullname);
            if (msgs == null) continue;
            for (String rec : msgs.keySet()) {
                Information inforec;
                if (rec.equals(fullname) || !(inforec = (Information)table.get(rec)).isComponentType() || struc.isInner(rec) && !this.superComposite(rec, inforec.getParents())) continue;
                anotherview.append(" Communications: to " + rec + " not in boundary of " + fullname + "\n");
            }
        }
    }

    public boolean superComposite(String rec, Vector<String> parents) {
        boolean result = true;
        for (String p : parents) {
            if (p.equals(rec)) {
                Fields struc = table.getStructure(p);
                result = result && struc.isInner(rec);
                continue;
            }
            return false;
        }
        return result;
    }

    public void displayFinalTable() {
        DisplayText anotherview = new DisplayText(shell.getDisplay(), "Final table");
        anotherview.setLocation(100, 100);
        anotherview.open();
        anotherview.append(table.toString());
        anotherview.append(separation);
        anotherview.append(" Nombre de types : " + this.typesOfInterest.size() + " Nombre de composants : " + table.getComponentNumber() + " Nombre de data type : " + table.getDatatypeNumber() + "\n");
        anotherview.append(separation);
        anotherview.append(" Liste avec cycle " + table.getCycles() + "\n");
        anotherview.append(separation);
        anotherview.append(" Liste undefined " + table.getUndefined() + "\n");
        anotherview.append(separation);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        shell = window.getShell();
    }

    public IWorkbenchWindow getWindow() {
        return this.window;
    }
}

