/*
 * Decompiled with CFR 0.152.
 */
package emn.fr.ascola.extractor;

import emn.fr.ascola.extractor.ASTActionDelegate;
import emn.fr.ascola.extractor.InfoCom;
import emn.fr.ascola.extractor.Information;
import emn.fr.ascola.extractor.MyIType;
import emn.fr.ascola.view.BasicCommunicationViewer;
import emn.fr.ascola.view.CheckedDialog;
import emn.fr.ascola.view.PrefuseViewer;
import java.util.Vector;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LaunchBasic
extends ASTActionDelegate {
    protected PrefuseViewer view;
    protected CheckedDialog cd;

    public void run(IAction action) {
        this.init(action);
        this.view = new BasicCommunicationViewer(this.repo_name);
        this.fillView();
    }

    protected void init(IAction action) {
        if (this.typesOfInterest.isEmpty()) {
            super.run(action);
        } else {
            boolean rep = MessageDialog.openQuestion((Shell)shell, (String)"New extraction (else current visualisation)", (String)"choose yes for a new extraction");
            if (rep) {
                super.run(action);
            }
        }
        this.cd = new CheckedDialog(new Shell(Display.getCurrent()));
        this.cd.open();
    }

    public void fillView() {
        this.addNodes(this.view);
        if (this.cd.isComposition()) {
            this.addComposites(this.view);
        }
        if (this.cd.isCommunication()) {
            this.addCommunications(this.view);
        }
        if (this.cd.isSubtyping()) {
            this.addSubtyping(this.view);
        }
        this.view.display();
    }

    public void addNodes(PrefuseViewer prefuseViewer) {
        for (String tname : ASTActionDelegate.table.keySet()) {
            Information info = (Information)ASTActionDelegate.table.get(tname);
            boolean cmp = info.isComponentType();
            Vector<String> all = ASTActionDelegate.provided.getProvided(tname);
            all.addAll(ASTActionDelegate.providedconstant.getProvided(tname));
            prefuseViewer.artefactAnalysis(tname, 10, cmp, all);
        }
    }

    public void addComposites(PrefuseViewer prefuseViewer) {
        for (String tname : ASTActionDelegate.table.keySet()) {
            Information info = (Information)ASTActionDelegate.table.get(tname);
            boolean cmp = info.isComponentType();
            if (!info.isResolved()) continue;
            MyIType ity = info.getIbind();
            if (!cmp || !ity.isNature()) continue;
            for (IVariableBinding ivb : ity.getStructure()) {
                String iname = ivb.getName();
                String itype = ivb.getType().getQualifiedName();
                prefuseViewer.artefactAnalysis(itype, 5, ((Information)ASTActionDelegate.table.get(itype)).isComponentType());
                prefuseViewer.edgeCreation(0, iname, tname, itype);
            }
        }
    }

    public void addCommunications(PrefuseViewer prefuseViewer) {
        prefuseViewer.setTableCount();
        for (String em : communications.keySet()) {
            InfoCom com = (InfoCom)communications.get(em);
            for (String rec : com.keySet()) {
                if (em.equals(rec)) continue;
                Vector vm = (Vector)com.get(rec);
                Vector<String> vecs = new Vector<String>();
                for (IMethodBinding m : vm) {
                    String rtype = m.getReturnType().getQualifiedName();
                    String ptypes = "";
                    ITypeBinding[] iTypeBindingArray = m.getParameterTypes();
                    int n = iTypeBindingArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITypeBinding it = iTypeBindingArray[n2];
                        ptypes = String.valueOf(ptypes) + it.getQualifiedName() + " ";
                        ++n2;
                    }
                    vecs.add(String.valueOf(m.getName()) + "(" + ptypes + ") -> " + rtype);
                    prefuseViewer.edgeCommunication("communications", em, rec, vecs);
                }
            }
        }
    }

    public void addSubtyping(PrefuseViewer prefuseViewer) {
        for (String tname : ASTActionDelegate.table.keySet()) {
            Information info = (Information)ASTActionDelegate.table.get(tname);
            MyIType ity = info.getIbind();
            for (String sub : ity.getSubclasses()) {
                prefuseViewer.edgeCreation(2, "subtyping", sub, tname);
            }
            for (String sub : ity.getSubinterfaces()) {
                prefuseViewer.edgeCreation(2, "subtyping", sub, tname);
            }
        }
    }
}

