/*
 * Decompiled with CFR 0.152.
 */
package emn.fr.ascola.extractor;

import emn.fr.ascola.extractor.ASTActionDelegate;
import emn.fr.ascola.extractor.Fields;
import emn.fr.ascola.extractor.Information;
import emn.fr.ascola.extractor.MyIType;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypesTable
extends HashMap<String, Information> {
    private static final long serialVersionUID = 1L;

    public TypesTable(Vector<IType> vt) {
        int i = 0;
        while (i < vt.size()) {
            this.put(vt.get(i).getFullyQualifiedName(), new Information());
            ++i;
        }
    }

    public boolean isOfInterest(String fn) {
        return this.containsKey(fn);
    }

    public boolean isDataType(String fn) {
        return ((Information)this.get(fn)).isDataType();
    }

    public boolean isResolved(String fn) {
        return ((Information)this.get(fn)).isResolved();
    }

    public boolean hasFields(String fn) {
        return ((Information)this.get(fn)).hasFields();
    }

    public void setDataType(String bn) {
        if (this.containsKey(bn)) {
            Information inf = (Information)this.get(bn);
            inf.setDataType(true);
            this.put(bn, inf);
        }
    }

    public void setComponentType(String bn) {
        if (this.containsKey(bn)) {
            Information inf = (Information)this.get(bn);
            inf.setComponentType(true);
            this.put(bn, inf);
        }
    }

    public void setRoot(String bn) {
        if (this.containsKey(bn)) {
            Information inf = (Information)this.get(bn);
            inf.setRoot();
            this.put(bn, inf);
        }
    }

    public void addType(String fn, Information it) {
        this.put(fn, it);
    }

    public void setType(String bn, MyIType it) {
        if (this.containsKey(bn)) {
            Information inf = (Information)this.get(bn);
            inf.setType(it);
            this.put(bn, inf);
        } else {
            MessageDialog.openError((Shell)ASTActionDelegate.shell, (String)"Error", (String)(" TypesTable.setType inconnu  " + bn));
        }
    }

    public boolean inheritsFromData(String sub, String sup) {
        boolean result = false;
        if (!sub.equals(sup) && this.isOfInterest(sub)) {
            String thesup;
            result = !this.isOfInterest(sup) ? true : (thesup = ((Information)this.get(sub)).getIbind().getSupername()).equals(sup) || this.inheritsFromData(thesup, sup);
        }
        return result;
    }

    public void propagateDATA() {
        for (String key : this.keySet()) {
            if (!((Information)this.get(key)).isDataType()) continue;
            MyIType ity = ((Information)this.get(key)).getIbind();
            for (String subc : ity.getSubclasses()) {
                ((Information)this.get(subc)).setDataType(true);
            }
            if (ity.isNature()) continue;
            for (String subi : ity.getSubinterfaces()) {
                ((Information)this.get(subi)).setDataType(true);
            }
        }
    }

    public Vector<String> checkPublicFields() {
        Vector<String> res = new Vector<String>();
        for (String key : this.keySet()) {
            Information info = (Information)this.get(key);
            MyIType ity = info.getIbind();
            if (!ity.isNature() || !info.isComponentType() || !ity.hasPublicFields()) continue;
            res.add(key);
        }
        return res;
    }

    public Vector<String> checkCycle() {
        for (String key : this.keySet()) {
            if (((Information)this.get(key)).isComponentType()) continue;
            ((Information)this.get(key)).setViewed(true);
        }
        Vector<String> res = new Vector<String>();
        for (String key : this.keySet()) {
            if (((Information)this.get(key)).isViewed()) continue;
            res.addAll(this.findCycle(key, new Vector<String>()));
        }
        return res;
    }

    public Vector<String> findCycle(String node, Vector<String> history) {
        Vector<String> res = new Vector<String>();
        Information info = (Information)this.get(node);
        if (history.contains(node)) {
            res.add(node);
            info.setCycle(true);
        } else {
            for (IVariableBinding f : info.getIbind().getStructure()) {
                String fname = f.getType().getBinaryName();
                Information inff = (Information)this.get(fname);
                if (inff.isViewed()) {
                    if (!inff.hasCycle()) continue;
                    if (!res.contains(node)) {
                        res.add(node);
                    }
                    info.setCycle(true);
                    continue;
                }
                history.add(node);
                for (String st : this.findCycle(fname, history)) {
                    if (res.contains(st)) continue;
                    res.add(st);
                }
            }
        }
        info.setViewed(true);
        return res;
    }

    public void setType(String bn) {
        this.put(bn, new Information());
    }

    public Fields getStructure(String fullname) {
        return ((Information)this.get(fullname)).getIbind().getStructure();
    }

    @Override
    public String toString() {
        String result = "";
        String sep = "%------------------------------\n";
        for (String key : this.keySet()) {
            result = String.valueOf(result) + sep + key + " ==> " + this.get(key) + "\n\n";
        }
        return result;
    }

    public int getComponentNumber() {
        int result = 0;
        for (String typ : this.keySet()) {
            if (!((Information)this.get(typ)).isComponentType()) continue;
            ++result;
        }
        return result;
    }

    public int getDatatypeNumber() {
        int result = 0;
        for (String typ : this.keySet()) {
            if (!((Information)this.get(typ)).isDataType()) continue;
            ++result;
        }
        return result;
    }

    public Vector<String> getCycles() {
        Vector<String> result = new Vector<String>();
        for (String typ : this.keySet()) {
            if (!((Information)this.get(typ)).isComponentType() || !((Information)this.get(typ)).hasCycle()) continue;
            result.add(typ);
        }
        return result;
    }

    public Vector<String> getUndefined() {
        Vector<String> result = new Vector<String>();
        for (String typ : this.keySet()) {
            if (!((Information)this.get(typ)).isUndefined()) continue;
            result.add(typ);
        }
        return result;
    }

    public void setUndefinedInterfaces() {
        for (String typ : this.keySet()) {
            Information ity = (Information)this.get(typ);
            if (!ity.isUndefined()) continue;
            if (!ity.getIbind().isNature()) {
                ity.setComponentType(true);
                continue;
            }
            System.err.println("TypesTable.setUndefinedInterfaces: problem with " + typ + " : " + ity);
        }
    }
}

