/*
 * Decompiled with CFR 0.152.
 */
package emn.fr.ascola.view;

import emn.fr.ascola.view.ATFItemView;
import emn.fr.ascola.view.PrefuseViewer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.animate.ColorAnimator;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.DataSizeAction;
import prefuse.action.assignment.FontAction;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.controls.DragControl;
import prefuse.controls.PanControl;
import prefuse.controls.ZoomControl;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.query.SearchQueryBinding;
import prefuse.data.search.SearchTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.visual.VisualItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicCommunicationViewer
extends PrefuseViewer {
    private static final long serialVersionUID = 1L;
    private ActionList animate = new ActionList(-1L);

    public BasicCommunicationViewer(String name) {
        super(name);
        this.defineSchema();
    }

    public void buildAndColor() {
        this.buildGraph();
        this.setRenderer();
        ColorAction nText = new ColorAction("graph.nodes", VisualItem.TEXTCOLOR);
        nText.setDefaultColor(ColorLib.rgb((int)250, (int)100, (int)0));
        ColorAction nStroke = new ColorAction("graph.nodes", VisualItem.STROKECOLOR);
        nStroke.setDefaultColor(ColorLib.gray((int)0));
        ColorAction nFill = new ColorAction("graph.nodes", VisualItem.FILLCOLOR);
        nFill.setDefaultColor(ColorLib.rgb((int)200, (int)250, (int)200));
        nFill.add(this.tocolorsources, ColorLib.rgb((int)100, (int)255, (int)250));
        nFill.add(this.tocolortargets, ColorLib.rgb((int)250, (int)100, (int)255));
        ColorAction nEdges = new ColorAction("graph.edges", VisualItem.STROKECOLOR);
        nEdges.setDefaultColor(ColorLib.gray((int)0));
        ColorAction edgeArrowColor = new ColorAction("graph.edges", VisualItem.FILLCOLOR);
        edgeArrowColor.setDefaultColor(ColorLib.gray((int)0));
        FontAction fonts = new FontAction("graph.nodes", FontLib.getFont((String)"Times", (double)16.0));
        fonts.add(datatype, FontLib.getFont((String)"Tahoma", (double)11.0));
        nText.add(datatype, ColorLib.rgb((int)0, (int)0, (int)255));
        nFill.add(datatype, ColorLib.rgb((int)150, (int)150, (int)100));
        nStroke.add(datatype, ColorLib.gray((int)100));
        DataSizeAction dsa = new DataSizeAction("graph.nodes", "level");
        dsa.setMaximumSize(100.0);
        dsa.setMaximumSize(10.0);
        ActionList draw = new ActionList();
        draw.add((Action)nText);
        draw.add((Action)nStroke);
        draw.add((Action)nFill);
        draw.add((Action)nEdges);
        draw.add((Action)edgeArrowColor);
        draw.add((Action)fonts);
        draw.add((Action)dsa);
        this.m_vis.putAction("draw", (Action)draw);
        NodeColorAction nodeColor = new NodeColorAction("graph.nodes");
        ActionList recolor = new ActionList();
        recolor.add((Action)nFill);
        recolor.add((Action)nStroke);
        recolor.add((Action)nEdges);
        recolor.add((Action)edgeArrowColor);
        recolor.add((Action)nodeColor);
        recolor.add((Action)nText);
        recolor.add((Action)dsa);
        this.m_vis.putAction("recolor", (Action)recolor);
        ActionList animatePaint = new ActionList(400L);
        animatePaint.add((Action)new ColorAnimator("graph.nodes"));
        animatePaint.add((Action)new RepaintAction());
        this.m_vis.putAction("animatePaint", (Action)animatePaint);
        EdgeColorAction nEdgesRecolor = new EdgeColorAction("graph.edges");
        ArrowColorAction edgeArrowRecolor = new ArrowColorAction("graph.edges");
        ActionList edgerecolor = new ActionList();
        edgerecolor.add((Action)nFill);
        edgerecolor.add((Action)nStroke);
        edgerecolor.add((Action)nText);
        edgerecolor.add((Action)nEdgesRecolor);
        edgerecolor.add((Action)edgeArrowRecolor);
        edgerecolor.add((Action)dsa);
        this.m_vis.putAction("edgerecolor", (Action)edgerecolor);
        this.animate.add((Action)new PrefuseViewer.DefaultForceDirectedLayout(this, "graph", true, 100));
        this.animate.add((Action)new RepaintAction());
        this.animate.add((Action)nFill);
        this.m_vis.putAction("animate", (Action)this.animate);
        this.m_vis.runAfter("draw", "animate");
        this.pan(250.0, 250.0);
        this.setHighQuality(true);
        this.addControlListener((Control)new ZoomControl());
        this.addControlListener((Control)new PanControl());
        this.addControlListener((Control)new DragControl());
        Point2D.Float down = new Point2D.Float(100.0f, 100.0f);
        this.zoom(down, 0.2);
        this.m_vis.run("draw");
        this.m_vis.addFocusGroup(Visualization.SEARCH_ITEMS, (TupleSet)this.thesearch);
        this.thesearch.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet t, Tuple[] add, Tuple[] rem) {
                BasicCommunicationViewer.this.m_vis.cancel("animatePaint");
                BasicCommunicationViewer.this.animate.cancel();
                BasicCommunicationViewer.this.stop.setText("Start Activity");
                BasicCommunicationViewer.this.m_vis.run("recolor");
                BasicCommunicationViewer.this.m_vis.run("animatePaint");
            }
        });
        this.m_vis.addFocusGroup("linkType", (TupleSet)this.theLinkSearch);
        this.theLinkSearch.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet t, Tuple[] add, Tuple[] rem) {
                BasicCommunicationViewer.this.m_vis.cancel("animatePaint");
                BasicCommunicationViewer.this.animate.cancel();
                BasicCommunicationViewer.this.stop.setText("Start Activity");
                BasicCommunicationViewer.this.m_vis.run("edgerecolor");
                BasicCommunicationViewer.this.m_vis.run("animatePaint");
            }
        });
    }

    @Override
    public void display() {
        this.buildAndColor();
        JFrame frame = new JFrame("Basic view for " + this.name);
        TupleSet ts = this.m_vis.getGroup("graph.nodes");
        SearchQueryBinding sq = new SearchQueryBinding((TupleSet)((Table)ts), "type", (SearchTupleSet)this.m_vis.getGroup(Visualization.SEARCH_ITEMS));
        this.search = sq.createSearchPanel();
        this.search.setLabelText("Search component type:");
        this.search.setShowResultCount(true);
        this.search.setBorder(BorderFactory.createEmptyBorder(5, 5, 4, 0));
        this.search.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)11));
        SearchQueryBinding sq2 = new SearchQueryBinding((TupleSet)((Table)this.m_vis.getGroup("graph.edges")), "name", (SearchTupleSet)this.m_vis.getGroup("linkType"));
        this.search2 = sq2.createSearchPanel();
        this.search2.setLabelText("Search link name:");
        this.search2.setShowResultCount(true);
        this.search2.setBorder(BorderFactory.createEmptyBorder(5, 5, 4, 0));
        this.search2.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)11));
        final ATFItemView lavue = new ATFItemView();
        this.addControlListener((Control)new ControlAdapter(){

            public void itemEntered(VisualItem item, MouseEvent e) {
                lavue.clean();
                lavue.setInfo(item);
                if (item.getGroup().equals("graph.nodes")) {
                    Node n = (Node)item;
                    n.setBoolean("sourceColor", true);
                    Graph graph = n.getGraph();
                    Iterator links = graph.outNeighbors(n);
                    while (links.hasNext()) {
                        Node loc = (Node)links.next();
                        loc.setBoolean("targetColor", true);
                    }
                } else {
                    Edge ed = (Edge)item;
                    ed.getSourceNode().setBoolean("sourceColor", true);
                    ed.getTargetNode().setBoolean("targetColor", true);
                }
            }

            public void itemExited(VisualItem item, MouseEvent e) {
                if (item.getGroup().equals("graph.nodes")) {
                    Node n = (Node)item;
                    n.setBoolean("sourceColor", false);
                    Graph graph = n.getGraph();
                    Iterator links = graph.outNeighbors(n);
                    while (links.hasNext()) {
                        Node loc = (Node)links.next();
                        loc.setBoolean("targetColor", false);
                    }
                } else {
                    Edge ed = (Edge)item;
                    ed.getSourceNode().setBoolean("sourceColor", false);
                    ed.getTargetNode().setBoolean("targetColor", false);
                }
            }

            public void itemClicked(VisualItem item, MouseEvent e) {
                JPopupMenu jpop = new JPopupMenu();
                if (item.getGroup().equals("graph.edges") && item.getInt("kind") == 1) {
                    jpop.add("List of communications");
                    jpop.addSeparator();
                    for (String st : (Vector)item.get("comm")) {
                        jpop.add(st);
                    }
                } else if (item.getGroup().equals("graph.nodes")) {
                    jpop.add("Provided interface");
                    jpop.addSeparator();
                    for (String st : (Vector)item.get("provided")) {
                        jpop.add(st);
                    }
                }
                jpop.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        this.stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JButton btn = (JButton)e.getSource();
                if ("Stop Activity".equals(btn.getText())) {
                    BasicCommunicationViewer.this.animate.cancel();
                    btn.setText("Start Activity");
                } else if ("Start Activity".equals(btn.getText())) {
                    BasicCommunicationViewer.this.m_vis.run("draw");
                    BasicCommunicationViewer.this.animate.run();
                    btn.setText("Stop Activity");
                }
            }
        });
        Box box = new Box(1);
        lavue.setAlignmentX(0.0f);
        lavue.setPreferredSize(new Dimension(800, 100));
        box.add(lavue);
        this.setAlignmentX(0.0f);
        box.add((Component)((Object)this));
        this.search.setPreferredSize(new Dimension(300, 30));
        this.search.setMaximumSize(new Dimension(500, 30));
        this.search.setAlignmentX(0.0f);
        this.search2.setPreferredSize(new Dimension(300, 30));
        this.search2.setMaximumSize(new Dimension(500, 30));
        this.search2.setAlignmentX(0.0f);
        Box bottom = new Box(1);
        bottom.setAlignmentX(0.0f);
        Box thebuttons = new Box(0);
        thebuttons.setAlignmentX(0.0f);
        thebuttons.add(this.stop);
        bottom.add(thebuttons);
        bottom.add((Component)this.search);
        bottom.add((Component)this.search2);
        box.add(bottom);
        frame.setLocation(50, 50);
        frame.setSize(800, 750);
        frame.setContentPane(box);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void edgeCommunication(String lname, String from, String to, Vector<String> comms) {
        if (!this.tableArtefact.containsKey(from)) {
            System.err.println("BasicCommunicationViewer.edgeCommunication " + from + " not existing node");
        }
        int src = (Integer)this.tableArtefact.get(from);
        if (!this.tableArtefact.containsKey(from)) {
            System.err.println("BasicCommunicationViewer.edgeCommunication " + to + " not existing node");
        }
        int tar = (Integer)this.tableArtefact.get(to);
        int rowe = this.edgedata.addRow();
        this.edgedata.set(rowe, "DEFAULT_SOURCE_KEY", (Object)src);
        this.edgedata.set(rowe, "DEFAULT_TARGET_KEY", (Object)tar);
        this.edgedata.set(rowe, "kind", (Object)1);
        this.edgedata.set(rowe, "name", (Object)lname);
        this.edgedata.set(rowe, "count", (Object)this.table[src][tar]);
        int[] nArray = this.table[src];
        int n = tar;
        nArray[n] = nArray[n] + 1;
        this.edgedata.set(rowe, "parameterTypes", (Object)"");
        this.edgedata.set(rowe, "returnType", (Object)"");
        this.edgedata.set(rowe, "comm", comms);
        this.edgedata.set(rowe, "emitter", (Object)from);
        this.edgedata.set(rowe, "receiver", (Object)to);
    }

    public void artefactNodeCreation(String type, int level, boolean data, int indice, Vector<String> provided) {
        int row = this.nodedata.addRow();
        this.nodedata.set(row, "DEFAULT_NODE_KEY", (Object)indice);
        this.nodedata.set(row, "level", (Object)100.0);
        this.nodedata.set(row, "type", (Object)type);
        this.nodedata.set(row, "kind", (Object)data);
        this.nodedata.set(row, "provided", provided);
        this.nodedata.set(row, "required", null);
    }

    @Override
    public int artefactAnalysis(String type, int level, boolean data, Vector<String> provided) {
        int indice;
        boolean check = this.tableArtefact.containsKey(type);
        if (check) {
            indice = (Integer)this.tableArtefact.get(type);
        } else {
            indice = this.ind++;
            this.tableArtefact.put(type, indice);
            this.artefactNodeCreation(type, level, data, indice, provided);
        }
        return indice;
    }

    public static class ArrowColorAction
    extends ColorAction {
        public ArrowColorAction(String group) {
            super(group, VisualItem.FILLCOLOR, ColorLib.gray((int)0));
            this.add(linkSearchPredicate, ColorLib.rgb((int)255, (int)100, (int)100));
            this.add(notLinkSearchPredicate, ColorLib.gray((int)255));
        }
    }

    public static class EdgeColorAction
    extends ColorAction {
        public EdgeColorAction(String group) {
            super(group, VisualItem.STROKECOLOR, ColorLib.gray((int)0));
            this.add(linkSearchPredicate, ColorLib.rgb((int)255, (int)100, (int)100));
            this.add(notLinkSearchPredicate, ColorLib.gray((int)255));
        }
    }

    public static class NodeColorAction
    extends ColorAction {
        public NodeColorAction(String group) {
            super(group, VisualItem.FILLCOLOR, ColorLib.rgba((int)255, (int)255, (int)255, (int)0));
            this.add("ingroup('_search_')", ColorLib.rgb((int)255, (int)100, (int)100));
        }
    }
}

