/*
 * Decompiled with CFR 0.152.
 */
package emn.fr.ascola.view;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import prefuse.render.EdgeRenderer;
import prefuse.util.GraphicsLib;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class MultiEdgeRenderer
extends EdgeRenderer {
    public MultiEdgeRenderer(int edgeTypeCurve, int edgeArrowForward) {
        super(edgeTypeCurve, edgeArrowForward);
    }

    protected void getCurveControlPoints(EdgeItem eitem, Point2D[] cp, double x1, double y1, double x4, double y4) {
        double dx = x4 - x1;
        double dy = y4 - y1;
        cp[0].setLocation(x1 + 2.0 * (dx *= (double)(1 + eitem.getInt("count"))) / 3.0, y1);
        cp[1].setLocation(x4 - dx / 8.0, y4 - (dy *= (double)(1 + eitem.getInt("count"))) / 8.0);
    }

    protected Shape getRawShape(VisualItem item) {
        EdgeItem edge = (EdgeItem)item;
        NodeItem item1 = edge.getSourceItem();
        NodeItem item2 = edge.getTargetItem();
        int type = this.m_edgeType;
        MultiEdgeRenderer.getAlignedPoint((Point2D)this.m_tmpPoints[0], (Rectangle2D)item1.getBounds(), (int)this.m_xAlign1, (int)this.m_yAlign1);
        MultiEdgeRenderer.getAlignedPoint((Point2D)this.m_tmpPoints[1], (Rectangle2D)item2.getBounds(), (int)this.m_xAlign2, (int)this.m_yAlign2);
        this.m_curWidth = (float)(this.m_width * this.getLineWidth(item));
        EdgeItem e = (EdgeItem)item;
        if (e.isDirected() && this.m_edgeArrow != 0) {
            NodeItem dest;
            boolean forward = this.m_edgeArrow == 1;
            Point2D start = null;
            Point2D end = null;
            start = this.m_tmpPoints[forward ? 0 : 1];
            int i = GraphicsLib.intersectLineRectangle((Point2D)start, (Point2D)(end = this.m_tmpPoints[forward ? 1 : 0]), (Rectangle2D)(dest = forward ? e.getTargetItem() : e.getSourceItem()).getBounds(), (Point2D[])this.m_isctPoints);
            if (i > 0) {
                end = this.m_isctPoints[0];
            }
            AffineTransform at = this.getArrowTrans(start, end, this.m_curWidth);
            this.m_curArrow = at.createTransformedShape(this.m_arrowHead);
            Point2D lineEnd = this.m_tmpPoints[forward ? 1 : 0];
            lineEnd.setLocation(0.0, -this.m_arrowHeight);
            at.transform(lineEnd, lineEnd);
        } else {
            this.m_curArrow = null;
        }
        Shape shape = null;
        double n1x = this.m_tmpPoints[0].getX();
        double n1y = this.m_tmpPoints[0].getY();
        double n2x = this.m_tmpPoints[1].getX();
        double n2y = this.m_tmpPoints[1].getY();
        switch (type) {
            case 0: {
                this.m_line.setLine(n1x, n1y, n2x, n2y);
                shape = this.m_line;
                break;
            }
            case 1: {
                int count = edge.getInt("count");
                if (item1 == item2) {
                    shape = new QuadCurve2D.Double(n1x + 10.0, n1y - 10.0, n1x - 100.0 + (double)(50 * count), n1y - 100.0 - (double)(10 * count), n2x, n2y);
                    break;
                }
                this.getCurveControlPoints(edge, this.m_ctrlPoints, n1x, n1y, n2x, n2y);
                shape = new CubicCurve2D.Double(n1x, n1y, this.m_ctrlPoints[0].getX(), this.m_ctrlPoints[0].getY(), this.m_ctrlPoints[1].getX(), this.m_ctrlPoints[1].getY(), n2x, n2y);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown edge type");
            }
        }
        return shape;
    }
}

