/*
 * Decompiled with CFR 0.152.
 */
package emn.fr.ascola.view;

import emn.fr.ascola.view.ATFItemView;
import emn.fr.ascola.view.BasicCommunicationViewer;
import emn.fr.ascola.view.MultiEdgeRenderer;
import emn.fr.ascola.view.PrefuseViewer;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.GroupAction;
import prefuse.action.RepaintAction;
import prefuse.action.animate.ColorAnimator;
import prefuse.action.animate.PolarLocationAnimator;
import prefuse.action.animate.QualityControlAnimator;
import prefuse.action.animate.VisibilityAnimator;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.DataSizeAction;
import prefuse.action.assignment.FontAction;
import prefuse.action.layout.CollapsedSubtreeLayout;
import prefuse.activity.Pacer;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.controls.DragControl;
import prefuse.controls.FocusControl;
import prefuse.controls.PanControl;
import prefuse.controls.ZoomControl;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.query.SearchQueryBinding;
import prefuse.data.search.SearchTupleSet;
import prefuse.data.tuple.DefaultTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.visual.VisualItem;
import prefuse.visual.sort.ItemSorter;
import prefuse.visual.sort.TreeDepthItemSorter;

public class PrefuseRadialViewer
extends BasicCommunicationViewer {
    private static final long serialVersionUID = 1L;
    private ActionList filter;
    private ActionList animate;
    private CollapsedSubtreeLayout subLayout;

    public PrefuseRadialViewer(String name) {
        super(name);
    }

    public void buildAndColor() {
        this.buildGraph();
        this.setRenderer();
        ColorAction nText = new ColorAction("graph.nodes", VisualItem.TEXTCOLOR);
        nText.setDefaultColor(ColorLib.rgb((int)250, (int)100, (int)0));
        ColorAction nStroke = new ColorAction("graph.nodes", VisualItem.STROKECOLOR);
        nStroke.setDefaultColor(ColorLib.gray((int)0));
        ColorAction nFill = new ColorAction("graph.nodes", VisualItem.FILLCOLOR);
        nFill.setDefaultColor(ColorLib.rgb((int)200, (int)250, (int)200));
        nFill.add(this.tocolorsources, ColorLib.rgb((int)100, (int)255, (int)250));
        nFill.add(this.tocolortargets, ColorLib.rgb((int)250, (int)100, (int)255));
        ColorAction nEdges = new ColorAction("graph.edges", VisualItem.STROKECOLOR);
        nEdges.setDefaultColor(ColorLib.gray((int)0));
        ColorAction edgeArrowColor = new ColorAction("graph.edges", VisualItem.FILLCOLOR);
        edgeArrowColor.setDefaultColor(ColorLib.gray((int)0));
        FontAction fonts = new FontAction("graph.nodes", FontLib.getFont((String)"Times", (double)16.0));
        fonts.add(datatype, FontLib.getFont((String)"Tahoma", (double)11.0));
        nText.add(datatype, ColorLib.rgb((int)0, (int)0, (int)255));
        nFill.add(datatype, ColorLib.rgb((int)150, (int)150, (int)100));
        nStroke.add(datatype, ColorLib.gray((int)100));
        DataSizeAction dsa = new DataSizeAction("graph.nodes", "level");
        dsa.setMaximumSize(100.0);
        dsa.setMaximumSize(10.0);
        ActionList draw = new ActionList();
        draw.add((Action)nText);
        draw.add((Action)nStroke);
        draw.add((Action)nFill);
        draw.add((Action)nEdges);
        draw.add((Action)edgeArrowColor);
        draw.add((Action)fonts);
        draw.add((Action)dsa);
        this.m_vis.putAction("draw", (Action)draw);
        BasicCommunicationViewer.NodeColorAction nodeColor = new BasicCommunicationViewer.NodeColorAction("graph.nodes");
        ActionList recolor = new ActionList();
        recolor.add((Action)nFill);
        recolor.add((Action)nStroke);
        recolor.add((Action)nEdges);
        recolor.add((Action)edgeArrowColor);
        recolor.add((Action)nodeColor);
        recolor.add((Action)nText);
        recolor.add((Action)dsa);
        this.m_vis.putAction("recolor", (Action)recolor);
        ActionList animatePaint = new ActionList(400L);
        animatePaint.add((Action)new ColorAnimator("graph.nodes"));
        animatePaint.add((Action)new RepaintAction());
        this.m_vis.putAction("animatePaint", (Action)animatePaint);
        BasicCommunicationViewer.EdgeColorAction nEdgesRecolor = new BasicCommunicationViewer.EdgeColorAction("graph.edges");
        BasicCommunicationViewer.ArrowColorAction edgeArrowRecolor = new BasicCommunicationViewer.ArrowColorAction("graph.edges");
        ActionList edgerecolor = new ActionList();
        edgerecolor.add((Action)nFill);
        edgerecolor.add((Action)nStroke);
        edgerecolor.add((Action)nText);
        edgerecolor.add((Action)nEdgesRecolor);
        edgerecolor.add((Action)edgeArrowRecolor);
        edgerecolor.add((Action)dsa);
        this.m_vis.putAction("edgerecolor", (Action)edgerecolor);
        PrefuseViewer.LongRadialTreeLayout treeLayout = new PrefuseViewer.LongRadialTreeLayout(this, "graph");
        treeLayout.setAngularBounds(-1.5707963267948966, Math.PI);
        this.m_vis.putAction("treeLayout", (Action)treeLayout);
        this.subLayout = new CollapsedSubtreeLayout("graph");
        this.m_vis.putAction("subLayout", (Action)this.subLayout);
        this.filter = new ActionList();
        this.filter.add((Action)new TreeRootAction("graph"));
        this.filter.add((Action)treeLayout);
        this.filter.add((Action)this.subLayout);
        this.filter.add((Action)nText);
        this.filter.add((Action)nFill);
        this.filter.add((Action)nStroke);
        this.filter.add((Action)nEdges);
        this.filter.add((Action)edgeArrowColor);
        this.filter.add((Action)dsa);
        this.m_vis.putAction("filter", (Action)this.filter);
        this.animate = new ActionList(500L);
        this.animate.setPacingFunction((Pacer)new SlowInSlowOutPacer());
        this.animate.add((Action)new QualityControlAnimator());
        this.animate.add((Action)new VisibilityAnimator("graph"));
        this.animate.add((Action)new PolarLocationAnimator("graph.nodes", "linear"));
        this.animate.add((Action)new ColorAnimator("graph.nodes"));
        this.animate.add((Action)new RepaintAction());
        this.m_vis.putAction("animate", (Action)this.animate);
        this.m_vis.alwaysRunAfter("filter", "animate");
        this.pan(250.0, 250.0);
        this.setHighQuality(true);
        this.setItemSorter((ItemSorter)new TreeDepthItemSorter());
        this.addControlListener((Control)new DragControl());
        this.addControlListener((Control)new ZoomControl());
        this.addControlListener((Control)new PanControl());
        this.addControlListener((Control)new NewFocusControl(1, "filter"));
        Point2D.Float down = new Point2D.Float(100.0f, 100.0f);
        double scale = this.getScale();
        this.zoom(down, 0.5 / scale);
        this.m_vis.run("filter");
        this.m_vis.addFocusGroup("linear", (TupleSet)new DefaultTupleSet());
        this.m_vis.getGroup(Visualization.FOCUS_ITEMS).addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet t, Tuple[] add, Tuple[] rem) {
                TupleSet linearInterp = PrefuseRadialViewer.this.m_vis.getGroup("linear");
                if (add.length < 1) {
                    return;
                }
                linearInterp.clear();
                Node n = (Node)add[0];
                while (n != null) {
                    linearInterp.addTuple((Tuple)n);
                    n = n.getParent();
                }
            }
        });
        this.m_vis.addFocusGroup(Visualization.SEARCH_ITEMS, (TupleSet)this.thesearch);
        this.thesearch.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet t, Tuple[] add, Tuple[] rem) {
                PrefuseRadialViewer.this.m_vis.cancel("animatePaint");
                PrefuseRadialViewer.this.animate.cancel();
                PrefuseRadialViewer.this.stop.setText("Start Activity");
                PrefuseRadialViewer.this.m_vis.run("recolor");
                PrefuseRadialViewer.this.m_vis.run("animatePaint");
            }
        });
        this.m_vis.addFocusGroup("linkType", (TupleSet)this.theLinkSearch);
        this.theLinkSearch.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet t, Tuple[] add, Tuple[] rem) {
                PrefuseRadialViewer.this.m_vis.cancel("animatePaint");
                PrefuseRadialViewer.this.animate.cancel();
                PrefuseRadialViewer.this.stop.setText("Start Activity");
                PrefuseRadialViewer.this.m_vis.run("edgerecolor");
                PrefuseRadialViewer.this.m_vis.run("animatePaint");
            }
        });
    }

    public void display() {
        this.buildAndColor();
        JFrame frame = new JFrame("Radial View for " + this.name);
        TupleSet ts = this.m_vis.getGroup("graph.nodes");
        SearchQueryBinding sq = new SearchQueryBinding((TupleSet)((Table)ts), "type", (SearchTupleSet)this.m_vis.getGroup(Visualization.SEARCH_ITEMS));
        this.search = sq.createSearchPanel();
        this.search.setLabelText("Search component type:");
        this.search.setShowResultCount(true);
        this.search.setBorder(BorderFactory.createEmptyBorder(5, 5, 4, 0));
        this.search.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)11));
        SearchQueryBinding sq2 = new SearchQueryBinding((TupleSet)((Table)this.m_vis.getGroup("graph.edges")), "name", (SearchTupleSet)this.m_vis.getGroup("linkType"));
        this.search2 = sq2.createSearchPanel();
        this.search2.setLabelText("Search link name:");
        this.search2.setShowResultCount(true);
        this.search2.setBorder(BorderFactory.createEmptyBorder(5, 5, 4, 0));
        this.search2.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)11));
        final ATFItemView lavue = new ATFItemView();
        this.addControlListener((Control)new ControlAdapter(){

            public void itemEntered(VisualItem item, MouseEvent e) {
                lavue.clean();
                lavue.setInfo(item);
            }

            public void itemClicked(VisualItem item, MouseEvent e) {
                if (e.getButton() == 2) {
                    JPopupMenu jpop = new JPopupMenu();
                    if (item.getGroup().equals("graph.edges") && item.getInt("kind") == 1) {
                        jpop.add("List of communications");
                        jpop.addSeparator();
                        for (String st : (Vector)item.get("comm")) {
                            jpop.add(st);
                        }
                    } else if (item.getGroup().equals("graph.nodes")) {
                        jpop.add("Provided interface");
                        jpop.addSeparator();
                        for (String st : (Vector)item.get("provided")) {
                            jpop.add(st);
                        }
                    }
                    jpop.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JButton btn = (JButton)e.getSource();
                if ("Stop Activity".equals(btn.getText())) {
                    PrefuseRadialViewer.this.animate.cancel();
                    btn.setText("Start Activity");
                } else if ("Start Activity".equals(btn.getText())) {
                    PrefuseRadialViewer.this.m_vis.run("draw");
                    PrefuseRadialViewer.this.animate.run();
                    btn.setText("Stop Activity");
                }
            }
        });
        Box box = new Box(1);
        lavue.setAlignmentX(0.0f);
        lavue.setPreferredSize(new Dimension(800, 100));
        box.add(lavue);
        this.setAlignmentX(0.0f);
        box.add((Component)((Object)this));
        this.search.setPreferredSize(new Dimension(300, 30));
        this.search.setMaximumSize(new Dimension(500, 30));
        this.search.setAlignmentX(0.0f);
        this.search2.setPreferredSize(new Dimension(300, 30));
        this.search2.setMaximumSize(new Dimension(500, 30));
        this.search2.setAlignmentX(0.0f);
        Box bottom = new Box(1);
        bottom.setAlignmentX(0.0f);
        Box thebuttons = new Box(0);
        thebuttons.setAlignmentX(0.0f);
        thebuttons.add(this.stop);
        bottom.add(thebuttons);
        bottom.add((Component)this.search);
        bottom.add((Component)this.search2);
        box.add(bottom);
        frame.setLocation(50, 50);
        frame.setSize(800, 750);
        frame.setContentPane(box);
        frame.pack();
        frame.setVisible(true);
    }

    public void setRenderer() {
        ComponentRenderer nodeRenderer = new ComponentRenderer();
        nodeRenderer.setHorizontalAlignment(2);
        nodeRenderer.setRoundedCorner(10, 10);
        DataRenderer otherRdr = new DataRenderer();
        otherRdr.setRoundedCorner(10, 10);
        MultiEdgeRenderer edgerM = new MultiEdgeRenderer(1, 1);
        edgerM.setDefaultLineWidth(4.0);
        edgerM.setArrowHeadSize(20, 20);
        PrefuseViewer.DashedEdgeRenderer otherM = new PrefuseViewer.DashedEdgeRenderer(this, 1, 1);
        otherM.setDefaultLineWidth(3.0);
        otherM.setArrowHeadSize(15, 15);
        PrefuseViewer.SubtypingEdgeRenderer subt = new PrefuseViewer.SubtypingEdgeRenderer(this, 0, 1);
        subt.setDefaultLineWidth(4.0);
        subt.setArrowHeadSize(20, 20);
        DefaultRendererFactory drf = new DefaultRendererFactory((Renderer)nodeRenderer);
        drf.add(datatype, (Renderer)otherRdr);
        drf.add(composite, (Renderer)edgerM);
        drf.add(communication, (Renderer)otherM);
        drf.add(subtyping, (Renderer)subt);
        this.m_vis.setRendererFactory((RendererFactory)drf);
    }

    public class ComponentRenderer
    extends LabelRenderer {
        public String getText(VisualItem vi) {
            return " " + vi.getInt("DEFAULT_NODE_KEY") + " ";
        }

        public BasicStroke getStroke(VisualItem vi) {
            return new BasicStroke(1.0f, 0, 0);
        }
    }

    public class DataRenderer
    extends ComponentRenderer {
        public BasicStroke getStroke(VisualItem vi) {
            return new BasicStroke(3.0f, 1, 1, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
        }
    }

    public static class NewFocusControl
    extends FocusControl {
        public NewFocusControl(int i, String string) {
            super(i, string);
        }

        protected boolean filterCheck(VisualItem item) {
            return item.getGroup().equals("graph.nodes");
        }
    }

    public static class TreeRootAction
    extends GroupAction {
        public TreeRootAction(String graphGroup) {
            super(graphGroup);
        }

        public void run(double frac) {
            TupleSet focus = this.m_vis.getGroup(Visualization.FOCUS_ITEMS);
            if (focus == null || focus.getTupleCount() == 0) {
                return;
            }
            Graph g = (Graph)this.m_vis.getGroup(this.m_group);
            Node f = null;
            Iterator tuples = focus.tuples();
            while (tuples.hasNext() && !g.containsTuple((Tuple)(f = (Node)tuples.next()))) {
                f = null;
            }
            if (f == null) {
                return;
            }
            g.getSpanningTree(f);
        }
    }
}

