/*
 * Decompiled with CFR 0.152.
 */
package emn.fr.ascola.view;

import emn.fr.ascola.view.MultiEdgeRenderer;
import java.awt.BasicStroke;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.layout.Layout;
import prefuse.action.layout.graph.BalloonTreeLayout;
import prefuse.action.layout.graph.ForceDirectedLayout;
import prefuse.action.layout.graph.RadialTreeLayout;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.expression.NotPredicate;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.search.PrefixSearchTupleSet;
import prefuse.data.search.SearchTupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.EdgeRenderer;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ui.JSearchPanel;
import prefuse.visual.EdgeItem;
import prefuse.visual.VisualItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrefuseViewer
extends Display {
    private static final long serialVersionUID = 1L;
    public static final String STRING_GRAPH = "graph";
    public static final String STRING_NODES = "graph.nodes";
    public static final String STRING_EDGES = "graph.edges";
    public static final String STRING_TYPE = "type";
    public static final String STRING_NAME = "name";
    public static final String STRING_KIND = "kind";
    public static final String STRING_LEVEL = "level";
    public static final String STRING_PTYPES = "parameterTypes";
    public static final String STRING_RTYPE = "returnType";
    public static final String STRING_COUNT = "count";
    public static final String STRING_COMM = "comm";
    public static final String STRING_EMITTER = "emitter";
    public static final String STRING_RECEIVER = "receiver";
    public static final String STRING_REQUIRED = "required";
    public static final String STRING_PROVIDED = "provided";
    public static final String linkSearch = "linkType";
    public static final int LABEL_MAX_SIZE = 10;
    public static final String STOP = "Stop Activity";
    public static final String START = "Start Activity";
    public static final double MAX_NODE_SIZE = 100.0;
    public static final double MIN_NODE_SIZE = 10.0;
    public static final String NULL_STRING = "";
    public static final String STRING_BASIC = "Default";
    public static final String STRING_SMALL = "Small";
    public static final String STRING_MIDDLE = "Middle";
    public static final String STRING_RADIAL = "Radial";
    public static final String STRING_CIRCLE = "Circle";
    public static final String STRING_BALLOON = "Balloon";
    public static final int COMPOSITE = 0;
    public static final int COMMUNICATION = 1;
    public static final int SUBTYPING = 2;
    protected Schema s_node = new Schema();
    protected Schema s_edge = new Schema();
    protected Table nodedata;
    protected Table edgedata;
    protected int ind = 1;
    protected HashMap<String, Integer> tableArtefact = new HashMap();
    protected int[][] table;
    public static final String linear = "linear";
    public static final Predicate communication = ExpressionParser.predicate((String)"INGROUP('graph.edges') AND kind == 1");
    public static final Predicate composite = ExpressionParser.predicate((String)"INGROUP('graph.edges') AND kind == 0");
    public static final Predicate subtyping = ExpressionParser.predicate((String)"INGROUP('graph.edges') AND kind == 2");
    public static final Predicate datatype = ExpressionParser.predicate((String)"INGROUP('graph.nodes') AND kind == false");
    public static final Predicate component = ExpressionParser.predicate((String)"INGROUP('graph.nodes') AND kind == true");
    public final Predicate tocolorsources = ExpressionParser.predicate((String)"sourceColor == true");
    public final Predicate tocolortargets = ExpressionParser.predicate((String)"targetColor == true");
    public static final Predicate linkSearchPredicate = ExpressionParser.predicate((String)"INGROUP('linkType')");
    public static final Predicate notLinkSearchPredicate = new NotPredicate(linkSearchPredicate);
    protected SearchTupleSet thesearch = new PrefixSearchTupleSet(true);
    protected SearchTupleSet theLinkSearch = new PrefixSearchTupleSet(true);
    protected JSearchPanel search;
    protected JSearchPanel search2;
    protected final JButton stop = new JButton("Stop Activity");
    protected String name;

    public PrefuseViewer(String name) {
        super(new Visualization());
        this.name = name;
    }

    public abstract void display();

    public void makeIt() {
        this.artefactAnalysis("TRUC", 10, true);
        this.artefactAnalysis("Machin", 9, false);
        this.artefactAnalysis("Bar", 9, false);
        this.edgeCreation(0, "foo", "TRUC", "Machin");
        this.edgeCreation(0, "bar", "TRUC", "Bar");
        this.artefactAnalysis("A", 1, true);
        this.artefactAnalysis("B", 1, true);
        this.edgeCreation(1, "msg(a, b)", "TRUC", "A");
        this.edgeCreation(1, "envoi(themachin)", "B", "A");
        this.edgeCreation(1, "autre", "B", "A");
        this.artefactAnalysis("10", 10, true);
        this.edgeCreation(0, "dix", "TRUC", "10");
        this.artefactAnalysis("20", 10, true);
        this.edgeCreation(0, "vingt", "TRUC", "20");
        this.edgeCreation(2, NULL_STRING, "A", "10");
        this.edgeCreation(2, NULL_STRING, "B", "Machin");
    }

    protected void buildGraph() {
        Graph g = new Graph(this.nodedata, this.edgedata, true, "DEFAULT_NODE_KEY", "DEFAULT_SOURCE_KEY", "DEFAULT_TARGET_KEY");
        this.m_vis.addGraph(STRING_GRAPH, g);
    }

    protected void defineSchema() {
        this.s_node.addColumn("DEFAULT_NODE_KEY", Integer.TYPE);
        this.s_node.addColumn(STRING_LEVEL, Double.TYPE);
        this.s_node.addColumn(STRING_TYPE, String.class);
        this.s_node.addColumn(STRING_KIND, Boolean.TYPE);
        this.s_node.addColumn(STRING_REQUIRED, Vector.class);
        this.s_node.addColumn(STRING_PROVIDED, Vector.class);
        this.s_edge.addColumn("DEFAULT_SOURCE_KEY", Integer.TYPE);
        this.s_edge.addColumn("DEFAULT_TARGET_KEY", Integer.TYPE);
        this.s_edge.addColumn(STRING_KIND, Integer.TYPE);
        this.s_edge.addColumn(STRING_NAME, String.class);
        this.s_edge.addColumn(STRING_COUNT, Integer.TYPE);
        this.s_edge.addColumn(STRING_PTYPES, String.class);
        this.s_edge.addColumn(STRING_RTYPE, String.class);
        this.s_edge.addColumn(STRING_COMM, Vector.class);
        this.s_edge.addColumn(STRING_EMITTER, String.class);
        this.s_edge.addColumn(STRING_RECEIVER, String.class);
        this.s_node.addColumn("sourceColor", Boolean.TYPE);
        this.s_node.addColumn("targetColor", Boolean.TYPE);
        this.nodedata = this.s_node.instantiate();
        this.edgedata = this.s_edge.instantiate();
    }

    public void artefactNodeCreation(String type, int level, boolean data, int indice) {
        int row = this.nodedata.addRow();
        this.nodedata.set(row, "DEFAULT_NODE_KEY", (Object)indice);
        this.nodedata.set(row, STRING_LEVEL, (Object)100.0);
        this.nodedata.set(row, STRING_TYPE, (Object)type);
        this.nodedata.set(row, STRING_KIND, (Object)data);
    }

    public int artefactAnalysis(String type, int level, boolean data) {
        int indice;
        boolean check = this.tableArtefact.containsKey(type);
        if (check) {
            indice = this.tableArtefact.get(type);
        } else {
            indice = this.ind++;
            this.tableArtefact.put(type, indice);
            this.artefactNodeCreation(type, level, data, indice);
        }
        return indice;
    }

    public void edgeCreation(int kind, String lname, String from, String to) {
        int src = this.tableArtefact.get(from);
        int tar = this.tableArtefact.get(to);
        int rowe = this.edgedata.addRow();
        this.edgedata.set(rowe, "DEFAULT_SOURCE_KEY", (Object)src);
        this.edgedata.set(rowe, "DEFAULT_TARGET_KEY", (Object)tar);
        this.edgedata.set(rowe, STRING_KIND, (Object)kind);
        this.edgedata.set(rowe, STRING_NAME, (Object)lname);
        this.edgedata.set(rowe, STRING_COUNT, (Object)1);
        this.edgedata.set(rowe, STRING_PTYPES, (Object)NULL_STRING);
        this.edgedata.set(rowe, STRING_RTYPE, (Object)NULL_STRING);
    }

    public void setTableCount() {
        int nb = this.nodedata.getTupleCount() + 1;
        this.table = new int[nb][nb];
    }

    public void edgeCommunication(String lname, String from, String to, String ptypes, String rtype) {
        int src = this.tableArtefact.get(from);
        int tar = this.tableArtefact.get(to);
        int rowe = this.edgedata.addRow();
        this.edgedata.set(rowe, "DEFAULT_SOURCE_KEY", (Object)src);
        this.edgedata.set(rowe, "DEFAULT_TARGET_KEY", (Object)tar);
        this.edgedata.set(rowe, STRING_KIND, (Object)1);
        this.edgedata.set(rowe, STRING_NAME, (Object)lname);
        this.edgedata.set(rowe, STRING_COUNT, (Object)this.table[src][tar]);
        int[] nArray = this.table[src];
        int n = tar;
        nArray[n] = nArray[n] + 1;
        this.edgedata.set(rowe, STRING_PTYPES, (Object)ptypes);
        this.edgedata.set(rowe, STRING_RTYPE, (Object)rtype);
    }

    public void setRenderer() {
        ComponentRenderer nodeRenderer = new ComponentRenderer();
        nodeRenderer.setHorizontalAlignment(2);
        DataRenderer otherRdr = new DataRenderer();
        otherRdr.setRoundedCorner(10, 10);
        MultiEdgeRenderer edgerM = new MultiEdgeRenderer(1, 1);
        edgerM.setDefaultLineWidth(4.0);
        edgerM.setArrowHeadSize(20, 20);
        DashedEdgeRenderer otherM = new DashedEdgeRenderer(1, 1);
        otherM.setDefaultLineWidth(3.0);
        otherM.setArrowHeadSize(15, 15);
        SubtypingEdgeRenderer subt = new SubtypingEdgeRenderer(0, 1);
        subt.setDefaultLineWidth(4.0);
        subt.setArrowHeadSize(20, 20);
        DefaultRendererFactory drf = new DefaultRendererFactory((Renderer)nodeRenderer);
        drf.add(datatype, (Renderer)otherRdr);
        drf.add(composite, (Renderer)edgerM);
        drf.add(communication, (Renderer)otherM);
        drf.add(subtyping, (Renderer)subt);
        this.m_vis.setRendererFactory((RendererFactory)drf);
    }

    public Layout getLayout(String key, int s) {
        if (key.equals(STRING_BASIC)) {
            return new DefaultForceDirectedLayout(STRING_GRAPH, true, s);
        }
        if (key.equals(STRING_CIRCLE)) {
            return new LongRadialTreeLayout(STRING_GRAPH);
        }
        if (key.equals(STRING_RADIAL)) {
            LongRadialTreeLayout tmp = new LongRadialTreeLayout(STRING_GRAPH);
            tmp.setAngularBounds(-1.5707963267948966, Math.PI);
            return tmp;
        }
        return new BalloonTreeLayout(STRING_GRAPH);
    }

    public abstract int artefactAnalysis(String var1, int var2, boolean var3, Vector<String> var4);

    public abstract void edgeCommunication(String var1, String var2, String var3, Vector<String> var4);

    public class ComponentRenderer
    extends LabelRenderer {
        public String getText(VisualItem vi) {
            String type = vi.getString(PrefuseViewer.STRING_TYPE);
            int last = type.lastIndexOf(".");
            String name = type;
            if (last != -1) {
                name = type.substring(last + 1);
            }
            return "\n " + name + " \n";
        }

        public BasicStroke getStroke(VisualItem vi) {
            return new BasicStroke(1.0f, 0, 0);
        }
    }

    public class DashedEdgeRenderer
    extends EdgeRenderer {
        public DashedEdgeRenderer(int edgetype, int arrowtype) {
            super(edgetype, arrowtype);
        }

        public BasicStroke getStroke(VisualItem vi) {
            return new BasicStroke(2.0f, 1, 1, 10.0f, new float[]{10.0f, 10.0f}, 0.0f);
        }
    }

    public class DataRenderer
    extends ComponentRenderer {
        public BasicStroke getStroke(VisualItem vi) {
            return new BasicStroke(3.0f, 1, 1, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
        }
    }

    public class DefaultForceDirectedLayout
    extends ForceDirectedLayout {
        private int nodes;

        public DefaultForceDirectedLayout(String group, boolean enforceBounds, int nb) {
            super(group, enforceBounds);
            this.nodes = 10;
            this.nodes = nb;
        }

        protected float getSpringLength(EdgeItem e) {
            Node s = e.getSourceNode();
            Node t = e.getTargetNode();
            int degree = s.getDegree() + t.getDegree();
            int k = degree / this.nodes;
            return 50 + 3 * this.nodes + 100 * k;
        }
    }

    public class LongRadialTreeLayout
    extends RadialTreeLayout {
        public LongRadialTreeLayout(String group) {
            super(group);
        }

        protected float getSpringLength(EdgeItem e) {
            return 600.0f;
        }
    }

    public class SubtypingEdgeRenderer
    extends EdgeRenderer {
        public SubtypingEdgeRenderer(int edgetype, int arrowtype) {
            super(edgetype, arrowtype);
        }

        public BasicStroke getStroke(VisualItem vi) {
            return new BasicStroke(4.0f, 1, 1, 10.0f, new float[]{10.0f, 3.0f, 2.0f, 3.0f, 10.0f}, 0.0f);
        }
    }
}

