/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package ccmm.architecture.util;

import ccmm.architecture.*;

import java.util.Map;

import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.emf.ecore.util.EObjectValidator;

import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.Query;

import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see ccmm.architecture.ArchitecturePackage
 * @generated
 */
public class ArchitectureValidator extends EObjectValidator {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final ArchitectureValidator INSTANCE = new ArchitectureValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "ccmm.architecture";

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * The parsed OCL expression for the definition of the '<em>validArchitecture</em>' invariant constraint.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static Constraint architecture_validArchitectureInvOCL;
	/**
	 * The parsed OCL expression for the definition of the '<em>distinctComponentNames</em>' invariant constraint.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static Constraint component_distinctComponentNamesInvOCL;

	/**
	 * The parsed OCL expression for the definition of the '<em>compatibleInterfaces</em>' invariant constraint.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static Constraint binding_compatibleInterfacesInvOCL;
	/**
	 * The parsed OCL expression for the definition of the '<em>validAssembly</em>' invariant constraint.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static Constraint assemblyBinding_validAssemblyInvOCL;
	/**
	 * The parsed OCL expression for the definition of the '<em>validDelegation</em>' invariant constraint.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static Constraint delegationBinding_validDelegationInvOCL;
	private static final String OCL_ANNOTATION_SOURCE = "http://www.eclipse.org/ocl/examples/OCL";
	
	private static final OCL OCL_ENV = OCL.newInstance();
	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArchitectureValidator() {
		super();
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage() {
	  return ArchitecturePackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresonding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
		switch (classifierID) {
			case ArchitecturePackage.ARCHITECTURE:
				return validateArchitecture((Architecture)value, diagnostics, context);
			case ArchitecturePackage.COMPONENT:
				return validateComponent((Component)value, diagnostics, context);
			case ArchitecturePackage.BINDING:
				return validateBinding((Binding)value, diagnostics, context);
			case ArchitecturePackage.ASSEMBLY_BINDING:
				return validateAssemblyBinding((AssemblyBinding)value, diagnostics, context);
			case ArchitecturePackage.DELEGATION_BINDING:
				return validateDelegationBinding((DelegationBinding)value, diagnostics, context);
			default: 
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateArchitecture(Architecture architecture, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(architecture, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(architecture, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(architecture, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(architecture, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(architecture, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(architecture, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(architecture, diagnostics, context);
		if (result || diagnostics != null) result &= validateArchitecture_validArchitecture(architecture, diagnostics, context);
		return result;
	}

	/**
	 * Validates the validArchitecture constraint of '<em>Architecture</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateArchitecture_validArchitecture(Architecture architecture, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (architecture_validArchitectureInvOCL == null) {
			OCL.Helper helper = OCL_ENV.createOCLHelper();
			helper.setContext(ArchitecturePackage.Literals.ARCHITECTURE);
			
			EAnnotation ocl = ArchitecturePackage.Literals.ARCHITECTURE.getEAnnotation(OCL_ANNOTATION_SOURCE);
			String expr = ocl.getDetails().get("validArchitecture");
			
			try {
				architecture_validArchitectureInvOCL = helper.createInvariant(expr);
			}
			catch (ParserException e) {
				throw new UnsupportedOperationException(e.getLocalizedMessage());
			}
		}
		
		Query<EClassifier, ?, ?> query = OCL_ENV.createQuery(architecture_validArchitectureInvOCL);
		
		if (!query.check(architecture)) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 DIAGNOSTIC_SOURCE,
						 0,
						 EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic", new Object[] { "validArchitecture", getObjectLabel(architecture, context) }),
						 new Object[] { architecture }));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateComponent(Component component, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(component, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(component, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(component, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(component, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(component, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(component, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(component, diagnostics, context);
		if (result || diagnostics != null) result &= validateComponent_distinctComponentNames(component, diagnostics, context);
		return result;
	}

	/**
	 * Validates the distinctComponentNames constraint of '<em>Component</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateComponent_distinctComponentNames(Component component, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (component_distinctComponentNamesInvOCL == null) {
			OCL.Helper helper = OCL_ENV.createOCLHelper();
			helper.setContext(ArchitecturePackage.Literals.COMPONENT);
			
			EAnnotation ocl = ArchitecturePackage.Literals.COMPONENT.getEAnnotation(OCL_ANNOTATION_SOURCE);
			String expr = ocl.getDetails().get("distinctComponentNames");
			
			try {
				component_distinctComponentNamesInvOCL = helper.createInvariant(expr);
			}
			catch (ParserException e) {
				throw new UnsupportedOperationException(e.getLocalizedMessage());
			}
		}
		
		Query<EClassifier, ?, ?> query = OCL_ENV.createQuery(component_distinctComponentNamesInvOCL);
		
		if (!query.check(component)) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 DIAGNOSTIC_SOURCE,
						 0,
						 EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic", new Object[] { "distinctComponentNames", getObjectLabel(component, context) }),
						 new Object[] { component }));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateBinding(Binding binding, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(binding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(binding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(binding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(binding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(binding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(binding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(binding, diagnostics, context);
		if (result || diagnostics != null) result &= validateBinding_compatibleInterfaces(binding, diagnostics, context);
		return result;
	}

	/**
	 * Validates the compatibleInterfaces constraint of '<em>Binding</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateBinding_compatibleInterfaces(Binding binding, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (binding_compatibleInterfacesInvOCL == null) {
			OCL.Helper helper = OCL_ENV.createOCLHelper();
			helper.setContext(ArchitecturePackage.Literals.BINDING);
			
			EAnnotation ocl = ArchitecturePackage.Literals.BINDING.getEAnnotation(OCL_ANNOTATION_SOURCE);
			String expr = ocl.getDetails().get("compatibleInterfaces");
			
			try {
				binding_compatibleInterfacesInvOCL = helper.createInvariant(expr);
			}
			catch (ParserException e) {
				throw new UnsupportedOperationException(e.getLocalizedMessage());
			}
		}
		
		Query<EClassifier, ?, ?> query = OCL_ENV.createQuery(binding_compatibleInterfacesInvOCL);
		
		if (!query.check(binding)) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 DIAGNOSTIC_SOURCE,
						 0,
						 EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic", new Object[] { "compatibleInterfaces", getObjectLabel(binding, context) }),
						 new Object[] { binding }));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAssemblyBinding(AssemblyBinding assemblyBinding, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(assemblyBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(assemblyBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(assemblyBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(assemblyBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(assemblyBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(assemblyBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(assemblyBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validateBinding_compatibleInterfaces(assemblyBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validateAssemblyBinding_validAssembly(assemblyBinding, diagnostics, context);
		return result;
	}

	/**
	 * Validates the validAssembly constraint of '<em>Assembly Binding</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAssemblyBinding_validAssembly(AssemblyBinding assemblyBinding, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (assemblyBinding_validAssemblyInvOCL == null) {
			OCL.Helper helper = OCL_ENV.createOCLHelper();
			helper.setContext(ArchitecturePackage.Literals.ASSEMBLY_BINDING);
			
			EAnnotation ocl = ArchitecturePackage.Literals.ASSEMBLY_BINDING.getEAnnotation(OCL_ANNOTATION_SOURCE);
			String expr = ocl.getDetails().get("validAssembly");
			
			try {
				assemblyBinding_validAssemblyInvOCL = helper.createInvariant(expr);
			}
			catch (ParserException e) {
				throw new UnsupportedOperationException(e.getLocalizedMessage());
			}
		}
		
		Query<EClassifier, ?, ?> query = OCL_ENV.createQuery(assemblyBinding_validAssemblyInvOCL);
		
		if (!query.check(assemblyBinding)) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 DIAGNOSTIC_SOURCE,
						 0,
						 EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic", new Object[] { "validAssembly", getObjectLabel(assemblyBinding, context) }),
						 new Object[] { assemblyBinding }));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDelegationBinding(DelegationBinding delegationBinding, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(delegationBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(delegationBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(delegationBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(delegationBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(delegationBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(delegationBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(delegationBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validateBinding_compatibleInterfaces(delegationBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validateDelegationBinding_validDelegation(delegationBinding, diagnostics, context);
		return result;
	}

	/**
	 * Validates the validDelegation constraint of '<em>Delegation Binding</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDelegationBinding_validDelegation(DelegationBinding delegationBinding, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (delegationBinding_validDelegationInvOCL == null) {
			OCL.Helper helper = OCL_ENV.createOCLHelper();
			helper.setContext(ArchitecturePackage.Literals.DELEGATION_BINDING);
			
			EAnnotation ocl = ArchitecturePackage.Literals.DELEGATION_BINDING.getEAnnotation(OCL_ANNOTATION_SOURCE);
			String expr = ocl.getDetails().get("validDelegation");
			
			try {
				delegationBinding_validDelegationInvOCL = helper.createInvariant(expr);
			}
			catch (ParserException e) {
				throw new UnsupportedOperationException(e.getLocalizedMessage());
			}
		}
		
		Query<EClassifier, ?, ?> query = OCL_ENV.createQuery(delegationBinding_validDelegationInvOCL);
		
		if (!query.check(delegationBinding)) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 DIAGNOSTIC_SOURCE,
						 0,
						 EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic", new Object[] { "validDelegation", getObjectLabel(delegationBinding, context) }),
						 new Object[] { delegationBinding }));
			}
			return false;
		}
		return true;
	}

} //ArchitectureValidator
