/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package ccmm.core;

import ccmm.basic.NamedElement;

import ccmm.repository.Repository;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Interface Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link ccmm.core.InterfaceType#getOperations <em>Operations</em>}</li>
 *   <li>{@link ccmm.core.InterfaceType#getRepository <em>Repository</em>}</li>
 * </ul>
 * </p>
 *
 * @see ccmm.core.CorePackage#getInterfaceType()
 * @model annotation="http://www.eclipse.org/emf/2002/Ecore constraints='distinctRepositoryNames2'"
 *        annotation="http://www.eclipse.org/ocl/examples/OCL distinctRepositoryNames2='self.repository.types->select(t | t.name = self.name)->size() = 0 and\r\nself.repository.interfaceTypes->select(it | it.name = self.name)->size() = 1 and\r\nself.repository.componentTypes->select(ct | ct.name = self.name)->size() = 0'"
 * @generated
 */
public interface InterfaceType extends NamedElement {
	/**
	 * Returns the value of the '<em><b>Operations</b></em>' containment reference list.
	 * The list contents are of type {@link ccmm.core.Operation}.
	 * It is bidirectional and its opposite is '{@link ccmm.core.Operation#getInterfaceType <em>Interface Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Operations</em>' containment reference list.
	 * @see ccmm.core.CorePackage#getInterfaceType_Operations()
	 * @see ccmm.core.Operation#getInterfaceType
	 * @model opposite="interfaceType" containment="true" required="true"
	 * @generated
	 */
	EList<Operation> getOperations();

	/**
	 * Returns the value of the '<em><b>Repository</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link ccmm.repository.Repository#getInterfaceTypes <em>Interface Types</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Repository</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Repository</em>' container reference.
	 * @see #setRepository(Repository)
	 * @see ccmm.core.CorePackage#getInterfaceType_Repository()
	 * @see ccmm.repository.Repository#getInterfaceTypes
	 * @model opposite="interfaceTypes" required="true"
	 * @generated
	 */
	Repository getRepository();

	/**
	 * Sets the value of the '{@link ccmm.core.InterfaceType#getRepository <em>Repository</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Repository</em>' container reference.
	 * @see #getRepository()
	 * @generated
	 */
	void setRepository(Repository value);

} // InterfaceType
