/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package ccmm.core;

import ccmm.basic.NamedElement;
import ccmm.basic.Type;

import ccmm.interfacespecification.Postcondition;
import ccmm.interfacespecification.Precondtion;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Operation</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link ccmm.core.Operation#getParameters <em>Parameters</em>}</li>
 *   <li>{@link ccmm.core.Operation#getReturnType <em>Return Type</em>}</li>
 *   <li>{@link ccmm.core.Operation#getInterfaceType <em>Interface Type</em>}</li>
 *   <li>{@link ccmm.core.Operation#getPostconditions <em>Postconditions</em>}</li>
 *   <li>{@link ccmm.core.Operation#getPreconditions <em>Preconditions</em>}</li>
 * </ul>
 * </p>
 *
 * @see ccmm.core.CorePackage#getOperation()
 * @model
 * @generated
 */
public interface Operation extends NamedElement {
	/**
	 * Returns the value of the '<em><b>Parameters</b></em>' containment reference list.
	 * The list contents are of type {@link ccmm.core.Parameter}.
	 * It is bidirectional and its opposite is '{@link ccmm.core.Parameter#getOperation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parameters</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Parameters</em>' containment reference list.
	 * @see ccmm.core.CorePackage#getOperation_Parameters()
	 * @see ccmm.core.Parameter#getOperation
	 * @model opposite="operation" containment="true"
	 * @generated
	 */
	EList<Parameter> getParameters();

	/**
	 * Returns the value of the '<em><b>Return Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Return Type</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Return Type</em>' reference.
	 * @see #setReturnType(Type)
	 * @see ccmm.core.CorePackage#getOperation_ReturnType()
	 * @model
	 * @generated
	 */
	Type getReturnType();

	/**
	 * Sets the value of the '{@link ccmm.core.Operation#getReturnType <em>Return Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Return Type</em>' reference.
	 * @see #getReturnType()
	 * @generated
	 */
	void setReturnType(Type value);

	/**
	 * Returns the value of the '<em><b>Interface Type</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link ccmm.core.InterfaceType#getOperations <em>Operations</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interface Type</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Interface Type</em>' container reference.
	 * @see #setInterfaceType(InterfaceType)
	 * @see ccmm.core.CorePackage#getOperation_InterfaceType()
	 * @see ccmm.core.InterfaceType#getOperations
	 * @model opposite="operations" required="true"
	 * @generated
	 */
	InterfaceType getInterfaceType();

	/**
	 * Sets the value of the '{@link ccmm.core.Operation#getInterfaceType <em>Interface Type</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Interface Type</em>' container reference.
	 * @see #getInterfaceType()
	 * @generated
	 */
	void setInterfaceType(InterfaceType value);

	/**
	 * Returns the value of the '<em><b>Postconditions</b></em>' containment reference list.
	 * The list contents are of type {@link ccmm.interfacespecification.Postcondition}.
	 * It is bidirectional and its opposite is '{@link ccmm.interfacespecification.Postcondition#getOperation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Postconditions</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Postconditions</em>' containment reference list.
	 * @see ccmm.core.CorePackage#getOperation_Postconditions()
	 * @see ccmm.interfacespecification.Postcondition#getOperation
	 * @model opposite="operation" containment="true"
	 * @generated
	 */
	EList<Postcondition> getPostconditions();

	/**
	 * Returns the value of the '<em><b>Preconditions</b></em>' containment reference list.
	 * The list contents are of type {@link ccmm.interfacespecification.Precondtion}.
	 * It is bidirectional and its opposite is '{@link ccmm.interfacespecification.Precondtion#getOperation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Preconditions</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Preconditions</em>' containment reference list.
	 * @see ccmm.core.CorePackage#getOperation_Preconditions()
	 * @see ccmm.interfacespecification.Precondtion#getOperation
	 * @model opposite="operation" containment="true"
	 * @generated
	 */
	EList<Precondtion> getPreconditions();

} // Operation
