/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package ccmm.core.impl;

import ccmm.basic.impl.NamedElementImpl;

import ccmm.core.ComponentType;
import ccmm.core.CorePackage;
import ccmm.core.Interface;
import ccmm.core.InterfaceType;

import ccmm.interfacespecification.InformationModel;
import ccmm.interfacespecification.InterfacespecificationPackage;
import ccmm.interfacespecification.Invariant;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Interface</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link ccmm.core.impl.InterfaceImpl#getPComponentType <em>PComponent Type</em>}</li>
 *   <li>{@link ccmm.core.impl.InterfaceImpl#getRComponentType <em>RComponent Type</em>}</li>
 *   <li>{@link ccmm.core.impl.InterfaceImpl#getInterfaceType <em>Interface Type</em>}</li>
 *   <li>{@link ccmm.core.impl.InterfaceImpl#getInformationModel <em>Information Model</em>}</li>
 *   <li>{@link ccmm.core.impl.InterfaceImpl#getInvariant <em>Invariant</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class InterfaceImpl extends NamedElementImpl implements Interface {
	/**
	 * The cached value of the '{@link #getInterfaceType() <em>Interface Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInterfaceType()
	 * @generated
	 * @ordered
	 */
	protected InterfaceType interfaceType;

	/**
	 * The cached value of the '{@link #getInformationModel() <em>Information Model</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInformationModel()
	 * @generated
	 * @ordered
	 */
	protected InformationModel informationModel;

	/**
	 * The cached value of the '{@link #getInvariant() <em>Invariant</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInvariant()
	 * @generated
	 * @ordered
	 */
	protected EList<Invariant> invariant;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterfaceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return CorePackage.Literals.INTERFACE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComponentType getPComponentType() {
		if (eContainerFeatureID != CorePackage.INTERFACE__PCOMPONENT_TYPE) return null;
		return (ComponentType)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPComponentType(ComponentType newPComponentType, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newPComponentType, CorePackage.INTERFACE__PCOMPONENT_TYPE, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPComponentType(ComponentType newPComponentType) {
		if (newPComponentType != eInternalContainer() || (eContainerFeatureID != CorePackage.INTERFACE__PCOMPONENT_TYPE && newPComponentType != null)) {
			if (EcoreUtil.isAncestor(this, newPComponentType))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newPComponentType != null)
				msgs = ((InternalEObject)newPComponentType).eInverseAdd(this, CorePackage.COMPONENT_TYPE__PROVIDED_INTERFACES, ComponentType.class, msgs);
			msgs = basicSetPComponentType(newPComponentType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CorePackage.INTERFACE__PCOMPONENT_TYPE, newPComponentType, newPComponentType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComponentType getRComponentType() {
		if (eContainerFeatureID != CorePackage.INTERFACE__RCOMPONENT_TYPE) return null;
		return (ComponentType)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRComponentType(ComponentType newRComponentType, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newRComponentType, CorePackage.INTERFACE__RCOMPONENT_TYPE, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRComponentType(ComponentType newRComponentType) {
		if (newRComponentType != eInternalContainer() || (eContainerFeatureID != CorePackage.INTERFACE__RCOMPONENT_TYPE && newRComponentType != null)) {
			if (EcoreUtil.isAncestor(this, newRComponentType))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newRComponentType != null)
				msgs = ((InternalEObject)newRComponentType).eInverseAdd(this, CorePackage.COMPONENT_TYPE__REQUIRED_INTERFACES, ComponentType.class, msgs);
			msgs = basicSetRComponentType(newRComponentType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CorePackage.INTERFACE__RCOMPONENT_TYPE, newRComponentType, newRComponentType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InterfaceType getInterfaceType() {
		if (interfaceType != null && interfaceType.eIsProxy()) {
			InternalEObject oldInterfaceType = (InternalEObject)interfaceType;
			interfaceType = (InterfaceType)eResolveProxy(oldInterfaceType);
			if (interfaceType != oldInterfaceType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, CorePackage.INTERFACE__INTERFACE_TYPE, oldInterfaceType, interfaceType));
			}
		}
		return interfaceType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InterfaceType basicGetInterfaceType() {
		return interfaceType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInterfaceType(InterfaceType newInterfaceType) {
		InterfaceType oldInterfaceType = interfaceType;
		interfaceType = newInterfaceType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CorePackage.INTERFACE__INTERFACE_TYPE, oldInterfaceType, interfaceType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InformationModel getInformationModel() {
		return informationModel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInformationModel(InformationModel newInformationModel, NotificationChain msgs) {
		InformationModel oldInformationModel = informationModel;
		informationModel = newInformationModel;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, CorePackage.INTERFACE__INFORMATION_MODEL, oldInformationModel, newInformationModel);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInformationModel(InformationModel newInformationModel) {
		if (newInformationModel != informationModel) {
			NotificationChain msgs = null;
			if (informationModel != null)
				msgs = ((InternalEObject)informationModel).eInverseRemove(this, InterfacespecificationPackage.INFORMATION_MODEL__INTERFACE, InformationModel.class, msgs);
			if (newInformationModel != null)
				msgs = ((InternalEObject)newInformationModel).eInverseAdd(this, InterfacespecificationPackage.INFORMATION_MODEL__INTERFACE, InformationModel.class, msgs);
			msgs = basicSetInformationModel(newInformationModel, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CorePackage.INTERFACE__INFORMATION_MODEL, newInformationModel, newInformationModel));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Invariant> getInvariant() {
		if (invariant == null) {
			invariant = new EObjectContainmentWithInverseEList<Invariant>(Invariant.class, this, CorePackage.INTERFACE__INVARIANT, InterfacespecificationPackage.INVARIANT__INTERFACE);
		}
		return invariant;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CorePackage.INTERFACE__PCOMPONENT_TYPE:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetPComponentType((ComponentType)otherEnd, msgs);
			case CorePackage.INTERFACE__RCOMPONENT_TYPE:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetRComponentType((ComponentType)otherEnd, msgs);
			case CorePackage.INTERFACE__INFORMATION_MODEL:
				if (informationModel != null)
					msgs = ((InternalEObject)informationModel).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - CorePackage.INTERFACE__INFORMATION_MODEL, null, msgs);
				return basicSetInformationModel((InformationModel)otherEnd, msgs);
			case CorePackage.INTERFACE__INVARIANT:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getInvariant()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CorePackage.INTERFACE__PCOMPONENT_TYPE:
				return basicSetPComponentType(null, msgs);
			case CorePackage.INTERFACE__RCOMPONENT_TYPE:
				return basicSetRComponentType(null, msgs);
			case CorePackage.INTERFACE__INFORMATION_MODEL:
				return basicSetInformationModel(null, msgs);
			case CorePackage.INTERFACE__INVARIANT:
				return ((InternalEList<?>)getInvariant()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID) {
			case CorePackage.INTERFACE__PCOMPONENT_TYPE:
				return eInternalContainer().eInverseRemove(this, CorePackage.COMPONENT_TYPE__PROVIDED_INTERFACES, ComponentType.class, msgs);
			case CorePackage.INTERFACE__RCOMPONENT_TYPE:
				return eInternalContainer().eInverseRemove(this, CorePackage.COMPONENT_TYPE__REQUIRED_INTERFACES, ComponentType.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case CorePackage.INTERFACE__PCOMPONENT_TYPE:
				return getPComponentType();
			case CorePackage.INTERFACE__RCOMPONENT_TYPE:
				return getRComponentType();
			case CorePackage.INTERFACE__INTERFACE_TYPE:
				if (resolve) return getInterfaceType();
				return basicGetInterfaceType();
			case CorePackage.INTERFACE__INFORMATION_MODEL:
				return getInformationModel();
			case CorePackage.INTERFACE__INVARIANT:
				return getInvariant();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case CorePackage.INTERFACE__PCOMPONENT_TYPE:
				setPComponentType((ComponentType)newValue);
				return;
			case CorePackage.INTERFACE__RCOMPONENT_TYPE:
				setRComponentType((ComponentType)newValue);
				return;
			case CorePackage.INTERFACE__INTERFACE_TYPE:
				setInterfaceType((InterfaceType)newValue);
				return;
			case CorePackage.INTERFACE__INFORMATION_MODEL:
				setInformationModel((InformationModel)newValue);
				return;
			case CorePackage.INTERFACE__INVARIANT:
				getInvariant().clear();
				getInvariant().addAll((Collection<? extends Invariant>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case CorePackage.INTERFACE__PCOMPONENT_TYPE:
				setPComponentType((ComponentType)null);
				return;
			case CorePackage.INTERFACE__RCOMPONENT_TYPE:
				setRComponentType((ComponentType)null);
				return;
			case CorePackage.INTERFACE__INTERFACE_TYPE:
				setInterfaceType((InterfaceType)null);
				return;
			case CorePackage.INTERFACE__INFORMATION_MODEL:
				setInformationModel((InformationModel)null);
				return;
			case CorePackage.INTERFACE__INVARIANT:
				getInvariant().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case CorePackage.INTERFACE__PCOMPONENT_TYPE:
				return getPComponentType() != null;
			case CorePackage.INTERFACE__RCOMPONENT_TYPE:
				return getRComponentType() != null;
			case CorePackage.INTERFACE__INTERFACE_TYPE:
				return interfaceType != null;
			case CorePackage.INTERFACE__INFORMATION_MODEL:
				return informationModel != null;
			case CorePackage.INTERFACE__INVARIANT:
				return invariant != null && !invariant.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //InterfaceImpl
