/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package ccmm.core.impl;

import ccmm.basic.Type;

import ccmm.basic.impl.NamedElementImpl;

import ccmm.core.CorePackage;
import ccmm.core.InterfaceType;
import ccmm.core.Operation;
import ccmm.core.Parameter;

import ccmm.interfacespecification.InterfacespecificationPackage;
import ccmm.interfacespecification.Postcondition;
import ccmm.interfacespecification.Precondtion;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Operation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link ccmm.core.impl.OperationImpl#getParameters <em>Parameters</em>}</li>
 *   <li>{@link ccmm.core.impl.OperationImpl#getReturnType <em>Return Type</em>}</li>
 *   <li>{@link ccmm.core.impl.OperationImpl#getInterfaceType <em>Interface Type</em>}</li>
 *   <li>{@link ccmm.core.impl.OperationImpl#getPostconditions <em>Postconditions</em>}</li>
 *   <li>{@link ccmm.core.impl.OperationImpl#getPreconditions <em>Preconditions</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class OperationImpl extends NamedElementImpl implements Operation {
	/**
	 * The cached value of the '{@link #getParameters() <em>Parameters</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParameters()
	 * @generated
	 * @ordered
	 */
	protected EList<Parameter> parameters;

	/**
	 * The cached value of the '{@link #getReturnType() <em>Return Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReturnType()
	 * @generated
	 * @ordered
	 */
	protected Type returnType;

	/**
	 * The cached value of the '{@link #getPostconditions() <em>Postconditions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPostconditions()
	 * @generated
	 * @ordered
	 */
	protected EList<Postcondition> postconditions;

	/**
	 * The cached value of the '{@link #getPreconditions() <em>Preconditions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPreconditions()
	 * @generated
	 * @ordered
	 */
	protected EList<Precondtion> preconditions;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OperationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return CorePackage.Literals.OPERATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Parameter> getParameters() {
		if (parameters == null) {
			parameters = new EObjectContainmentWithInverseEList<Parameter>(Parameter.class, this, CorePackage.OPERATION__PARAMETERS, CorePackage.PARAMETER__OPERATION);
		}
		return parameters;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Type getReturnType() {
		if (returnType != null && returnType.eIsProxy()) {
			InternalEObject oldReturnType = (InternalEObject)returnType;
			returnType = (Type)eResolveProxy(oldReturnType);
			if (returnType != oldReturnType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, CorePackage.OPERATION__RETURN_TYPE, oldReturnType, returnType));
			}
		}
		return returnType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Type basicGetReturnType() {
		return returnType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReturnType(Type newReturnType) {
		Type oldReturnType = returnType;
		returnType = newReturnType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CorePackage.OPERATION__RETURN_TYPE, oldReturnType, returnType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InterfaceType getInterfaceType() {
		if (eContainerFeatureID != CorePackage.OPERATION__INTERFACE_TYPE) return null;
		return (InterfaceType)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInterfaceType(InterfaceType newInterfaceType, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newInterfaceType, CorePackage.OPERATION__INTERFACE_TYPE, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInterfaceType(InterfaceType newInterfaceType) {
		if (newInterfaceType != eInternalContainer() || (eContainerFeatureID != CorePackage.OPERATION__INTERFACE_TYPE && newInterfaceType != null)) {
			if (EcoreUtil.isAncestor(this, newInterfaceType))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newInterfaceType != null)
				msgs = ((InternalEObject)newInterfaceType).eInverseAdd(this, CorePackage.INTERFACE_TYPE__OPERATIONS, InterfaceType.class, msgs);
			msgs = basicSetInterfaceType(newInterfaceType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CorePackage.OPERATION__INTERFACE_TYPE, newInterfaceType, newInterfaceType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Postcondition> getPostconditions() {
		if (postconditions == null) {
			postconditions = new EObjectContainmentWithInverseEList<Postcondition>(Postcondition.class, this, CorePackage.OPERATION__POSTCONDITIONS, InterfacespecificationPackage.POSTCONDITION__OPERATION);
		}
		return postconditions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Precondtion> getPreconditions() {
		if (preconditions == null) {
			preconditions = new EObjectContainmentWithInverseEList<Precondtion>(Precondtion.class, this, CorePackage.OPERATION__PRECONDITIONS, InterfacespecificationPackage.PRECONDTION__OPERATION);
		}
		return preconditions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CorePackage.OPERATION__PARAMETERS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getParameters()).basicAdd(otherEnd, msgs);
			case CorePackage.OPERATION__INTERFACE_TYPE:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetInterfaceType((InterfaceType)otherEnd, msgs);
			case CorePackage.OPERATION__POSTCONDITIONS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getPostconditions()).basicAdd(otherEnd, msgs);
			case CorePackage.OPERATION__PRECONDITIONS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getPreconditions()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CorePackage.OPERATION__PARAMETERS:
				return ((InternalEList<?>)getParameters()).basicRemove(otherEnd, msgs);
			case CorePackage.OPERATION__INTERFACE_TYPE:
				return basicSetInterfaceType(null, msgs);
			case CorePackage.OPERATION__POSTCONDITIONS:
				return ((InternalEList<?>)getPostconditions()).basicRemove(otherEnd, msgs);
			case CorePackage.OPERATION__PRECONDITIONS:
				return ((InternalEList<?>)getPreconditions()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID) {
			case CorePackage.OPERATION__INTERFACE_TYPE:
				return eInternalContainer().eInverseRemove(this, CorePackage.INTERFACE_TYPE__OPERATIONS, InterfaceType.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case CorePackage.OPERATION__PARAMETERS:
				return getParameters();
			case CorePackage.OPERATION__RETURN_TYPE:
				if (resolve) return getReturnType();
				return basicGetReturnType();
			case CorePackage.OPERATION__INTERFACE_TYPE:
				return getInterfaceType();
			case CorePackage.OPERATION__POSTCONDITIONS:
				return getPostconditions();
			case CorePackage.OPERATION__PRECONDITIONS:
				return getPreconditions();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case CorePackage.OPERATION__PARAMETERS:
				getParameters().clear();
				getParameters().addAll((Collection<? extends Parameter>)newValue);
				return;
			case CorePackage.OPERATION__RETURN_TYPE:
				setReturnType((Type)newValue);
				return;
			case CorePackage.OPERATION__INTERFACE_TYPE:
				setInterfaceType((InterfaceType)newValue);
				return;
			case CorePackage.OPERATION__POSTCONDITIONS:
				getPostconditions().clear();
				getPostconditions().addAll((Collection<? extends Postcondition>)newValue);
				return;
			case CorePackage.OPERATION__PRECONDITIONS:
				getPreconditions().clear();
				getPreconditions().addAll((Collection<? extends Precondtion>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case CorePackage.OPERATION__PARAMETERS:
				getParameters().clear();
				return;
			case CorePackage.OPERATION__RETURN_TYPE:
				setReturnType((Type)null);
				return;
			case CorePackage.OPERATION__INTERFACE_TYPE:
				setInterfaceType((InterfaceType)null);
				return;
			case CorePackage.OPERATION__POSTCONDITIONS:
				getPostconditions().clear();
				return;
			case CorePackage.OPERATION__PRECONDITIONS:
				getPreconditions().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case CorePackage.OPERATION__PARAMETERS:
				return parameters != null && !parameters.isEmpty();
			case CorePackage.OPERATION__RETURN_TYPE:
				return returnType != null;
			case CorePackage.OPERATION__INTERFACE_TYPE:
				return getInterfaceType() != null;
			case CorePackage.OPERATION__POSTCONDITIONS:
				return postconditions != null && !postconditions.isEmpty();
			case CorePackage.OPERATION__PRECONDITIONS:
				return preconditions != null && !preconditions.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //OperationImpl
