/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package ccmm.architecture;

import ccmm.core.ComponentType;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Architecture</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link ccmm.architecture.Architecture#getComponentType <em>Component Type</em>}</li>
 *   <li>{@link ccmm.architecture.Architecture#getComponents <em>Components</em>}</li>
 *   <li>{@link ccmm.architecture.Architecture#getBindings <em>Bindings</em>}</li>
 * </ul>
 * </p>
 *
 * @see ccmm.architecture.ArchitecturePackage#getArchitecture()
 * @model annotation="http://www.eclipse.org/emf/2002/Ecore constraints='validArchitecture'"
 *        annotation="http://www.eclipse.org/ocl/examples/OCL validArchitecture='self.components->select(c:Component | c.componentType = self.componentType)->isEmpty()'"
 * @generated
 */
public interface Architecture extends EObject {
	/**
	 * Returns the value of the '<em><b>Component Type</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link ccmm.core.ComponentType#getArchitecture <em>Architecture</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Component Type</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Component Type</em>' container reference.
	 * @see #setComponentType(ComponentType)
	 * @see ccmm.architecture.ArchitecturePackage#getArchitecture_ComponentType()
	 * @see ccmm.core.ComponentType#getArchitecture
	 * @model opposite="architecture" required="true"
	 * @generated
	 */
	ComponentType getComponentType();

	/**
	 * Sets the value of the '{@link ccmm.architecture.Architecture#getComponentType <em>Component Type</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Component Type</em>' container reference.
	 * @see #getComponentType()
	 * @generated
	 */
	void setComponentType(ComponentType value);

	/**
	 * Returns the value of the '<em><b>Components</b></em>' containment reference list.
	 * The list contents are of type {@link ccmm.architecture.Component}.
	 * It is bidirectional and its opposite is '{@link ccmm.architecture.Component#getArchitecture <em>Architecture</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Components</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Components</em>' containment reference list.
	 * @see ccmm.architecture.ArchitecturePackage#getArchitecture_Components()
	 * @see ccmm.architecture.Component#getArchitecture
	 * @model opposite="architecture" containment="true" required="true"
	 * @generated
	 */
	EList<Component> getComponents();

	/**
	 * Returns the value of the '<em><b>Bindings</b></em>' containment reference list.
	 * The list contents are of type {@link ccmm.architecture.Binding}.
	 * It is bidirectional and its opposite is '{@link ccmm.architecture.Binding#getArchitecture <em>Architecture</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Bindings</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Bindings</em>' containment reference list.
	 * @see ccmm.architecture.ArchitecturePackage#getArchitecture_Bindings()
	 * @see ccmm.architecture.Binding#getArchitecture
	 * @model opposite="architecture" containment="true" required="true"
	 * @generated
	 */
	EList<Binding> getBindings();

} // Architecture
