/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package ccmm.repository.impl;

import ccmm.basic.BasicPackage;
import ccmm.basic.Type;

import ccmm.core.ComponentType;
import ccmm.core.CorePackage;
import ccmm.core.InterfaceType;

import ccmm.repository.Repository;
import ccmm.repository.RepositoryPackage;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.expressions.OCLExpression;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Repository</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link ccmm.repository.impl.RepositoryImpl#getComponentTypes <em>Component Types</em>}</li>
 *   <li>{@link ccmm.repository.impl.RepositoryImpl#getInterfaceTypes <em>Interface Types</em>}</li>
 *   <li>{@link ccmm.repository.impl.RepositoryImpl#getTypes <em>Types</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class RepositoryImpl extends EObjectImpl implements Repository {
	/**
	 * The cached value of the '{@link #getComponentTypes() <em>Component Types</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getComponentTypes()
	 * @generated
	 * @ordered
	 */
	protected EList<ComponentType> componentTypes;

	/**
	 * The cached value of the '{@link #getInterfaceTypes() <em>Interface Types</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInterfaceTypes()
	 * @generated
	 * @ordered
	 */
	protected EList<InterfaceType> interfaceTypes;

	/**
	 * The cached value of the '{@link #getTypes() <em>Types</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTypes()
	 * @generated
	 * @ordered
	 */
	protected EList<Type> types;

	/**
	 * The parsed OCL expression for the body of the '{@link #getComponentTypesWithProvidedInterfaceType <em>Get Component Types With Provided Interface Type</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getComponentTypesWithProvidedInterfaceType
	 * @generated
	 */
	private static OCLExpression<EClassifier> getComponentTypesWithProvidedInterfaceTypeBodyOCL;

	private static final String OCL_ANNOTATION_SOURCE = "http://www.eclipse.org/ocl/examples/OCL";

	private static final OCL OCL_ENV = OCL.newInstance();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RepositoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return RepositoryPackage.Literals.REPOSITORY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ComponentType> getComponentTypes() {
		if (componentTypes == null) {
			componentTypes = new EObjectContainmentWithInverseEList<ComponentType>(ComponentType.class, this, RepositoryPackage.REPOSITORY__COMPONENT_TYPES, CorePackage.COMPONENT_TYPE__REPOSITORY);
		}
		return componentTypes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<InterfaceType> getInterfaceTypes() {
		if (interfaceTypes == null) {
			interfaceTypes = new EObjectContainmentWithInverseEList<InterfaceType>(InterfaceType.class, this, RepositoryPackage.REPOSITORY__INTERFACE_TYPES, CorePackage.INTERFACE_TYPE__REPOSITORY);
		}
		return interfaceTypes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Type> getTypes() {
		if (types == null) {
			types = new EObjectContainmentWithInverseEList<Type>(Type.class, this, RepositoryPackage.REPOSITORY__TYPES, BasicPackage.TYPE__REPOSITORY);
		}
		return types;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<EList<?>> getComponentTypesWithProvidedInterfaceType(InterfaceType it) {
		if (getComponentTypesWithProvidedInterfaceTypeBodyOCL == null) {
			EOperation eOperation = RepositoryPackage.Literals.REPOSITORY.getEOperations().get(0);
			OCL.Helper helper = OCL_ENV.createOCLHelper();
			helper.setOperationContext(RepositoryPackage.Literals.REPOSITORY, eOperation);
			EAnnotation ocl = eOperation.getEAnnotation(OCL_ANNOTATION_SOURCE);
			String body = ocl.getDetails().get("body");
			
			try {
				getComponentTypesWithProvidedInterfaceTypeBodyOCL = helper.createQuery(body);
			} catch (ParserException e) {
				throw new UnsupportedOperationException(e.getLocalizedMessage());
			}
		}
		
		Query<EClassifier, ?, ?> query = OCL_ENV.createQuery(getComponentTypesWithProvidedInterfaceTypeBodyOCL);
	 
		EvaluationEnvironment<?, ?, ?, ?, ?> evalEnv = query.getEvaluationEnvironment();
		
		evalEnv.add("it", it);
	  
		@SuppressWarnings("unchecked")
		Collection<EList<?>> result = (Collection<EList<?>>) query.evaluate(this);
		return new BasicEList.UnmodifiableEList<EList<?>>(result.size(), result.toArray());
	
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RepositoryPackage.REPOSITORY__COMPONENT_TYPES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getComponentTypes()).basicAdd(otherEnd, msgs);
			case RepositoryPackage.REPOSITORY__INTERFACE_TYPES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getInterfaceTypes()).basicAdd(otherEnd, msgs);
			case RepositoryPackage.REPOSITORY__TYPES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getTypes()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case RepositoryPackage.REPOSITORY__COMPONENT_TYPES:
				return ((InternalEList<?>)getComponentTypes()).basicRemove(otherEnd, msgs);
			case RepositoryPackage.REPOSITORY__INTERFACE_TYPES:
				return ((InternalEList<?>)getInterfaceTypes()).basicRemove(otherEnd, msgs);
			case RepositoryPackage.REPOSITORY__TYPES:
				return ((InternalEList<?>)getTypes()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case RepositoryPackage.REPOSITORY__COMPONENT_TYPES:
				return getComponentTypes();
			case RepositoryPackage.REPOSITORY__INTERFACE_TYPES:
				return getInterfaceTypes();
			case RepositoryPackage.REPOSITORY__TYPES:
				return getTypes();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case RepositoryPackage.REPOSITORY__COMPONENT_TYPES:
				getComponentTypes().clear();
				getComponentTypes().addAll((Collection<? extends ComponentType>)newValue);
				return;
			case RepositoryPackage.REPOSITORY__INTERFACE_TYPES:
				getInterfaceTypes().clear();
				getInterfaceTypes().addAll((Collection<? extends InterfaceType>)newValue);
				return;
			case RepositoryPackage.REPOSITORY__TYPES:
				getTypes().clear();
				getTypes().addAll((Collection<? extends Type>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case RepositoryPackage.REPOSITORY__COMPONENT_TYPES:
				getComponentTypes().clear();
				return;
			case RepositoryPackage.REPOSITORY__INTERFACE_TYPES:
				getInterfaceTypes().clear();
				return;
			case RepositoryPackage.REPOSITORY__TYPES:
				getTypes().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case RepositoryPackage.REPOSITORY__COMPONENT_TYPES:
				return componentTypes != null && !componentTypes.isEmpty();
			case RepositoryPackage.REPOSITORY__INTERFACE_TYPES:
				return interfaceTypes != null && !interfaceTypes.isEmpty();
			case RepositoryPackage.REPOSITORY__TYPES:
				return types != null && !types.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //RepositoryImpl
